/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.event.logger;

import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.wildfly.event.logger.Event;
import org.wildfly.event.logger.EventFormatter;

public class JsonEventFormatter
implements EventFormatter {
    private final JsonBuilderFactory factory;
    private final Map<String, Object> metaData;
    private final String timestampKey;
    private final DateTimeFormatter formatter;
    private final boolean includeTimestamp;

    private JsonEventFormatter(Map<String, Object> metaData, String timestampKey, DateTimeFormatter formatter, boolean includeTimestamp) {
        this.metaData = metaData;
        this.timestampKey = timestampKey;
        this.formatter = formatter;
        this.includeTimestamp = includeTimestamp;
        this.factory = Json.createBuilderFactory(Collections.emptyMap());
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String format(Event event) {
        JsonObjectBuilder builder = this.factory.createObjectBuilder();
        builder.add("eventSource", event.getSource());
        if (this.includeTimestamp) {
            builder.add(this.timestampKey, this.formatter.format(event.getInstant()));
        }
        this.add(builder, this.metaData);
        this.add(builder, event.getData());
        return builder.build().toString();
    }

    private void add(JsonObjectBuilder builder, Map<String, Object> data) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                builder.addNull(key);
                continue;
            }
            if (value instanceof Boolean) {
                builder.add(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Double) {
                builder.add(key, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Integer) {
                builder.add(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                builder.add(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof String) {
                builder.add(key, (String)value);
                continue;
            }
            if (value instanceof BigDecimal) {
                builder.add(key, (BigDecimal)value);
                continue;
            }
            if (value instanceof BigInteger) {
                builder.add(key, (BigInteger)value);
                continue;
            }
            if (value instanceof Collection) {
                builder.add(key, this.factory.createArrayBuilder((Collection)value));
                continue;
            }
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                JsonObjectBuilder valueBuilder = this.factory.createObjectBuilder();
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                for (Map.Entry valueEntry : mapValue.entrySet()) {
                    Object valueKey = valueEntry.getKey();
                    Object valueValue = valueEntry.getValue();
                    if (valueKey instanceof String) {
                        map.put((String)valueKey, valueValue);
                        continue;
                    }
                    map.put(String.valueOf(valueKey), valueValue);
                }
                this.add(valueBuilder, map);
                builder.add(key, valueBuilder);
                continue;
            }
            if (value instanceof JsonArrayBuilder) {
                builder.add(key, (JsonArrayBuilder)value);
                continue;
            }
            if (value instanceof JsonObjectBuilder) {
                builder.add(key, (JsonObjectBuilder)value);
                continue;
            }
            if (value instanceof JsonValue) {
                builder.add(key, (JsonValue)value);
                continue;
            }
            if (value.getClass().isArray()) {
                builder.add(key, this.factory.createArrayBuilder(Arrays.asList((Object[])value)));
                continue;
            }
            builder.add(key, String.valueOf(value));
        }
    }

    public static class Builder {
        private Map<String, Object> metaData = new LinkedHashMap<String, Object>();
        private String timestampKey;
        private DateTimeFormatter formatter;
        private ZoneId zoneId;
        private boolean includeTimestamp = true;

        private Builder() {
        }

        public Builder addMetaData(String key, Object value) {
            if (this.metaData == null) {
                this.metaData = new LinkedHashMap<String, Object>();
            }
            this.metaData.put(key, value);
            return this;
        }

        public Builder addMetaData(Map<String, Object> metaData) {
            if (this.metaData == null) {
                this.metaData = new LinkedHashMap<String, Object>();
            }
            this.metaData.putAll(metaData);
            return this;
        }

        public Builder setTimestampKey(String timestampKey) {
            this.timestampKey = timestampKey;
            return this;
        }

        public Builder setTimestampFormatter(DateTimeFormatter formatter) {
            this.formatter = formatter;
            return this;
        }

        public Builder setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder setIncludeTimestamp(boolean includeTimestamp) {
            this.includeTimestamp = includeTimestamp;
            return this;
        }

        public JsonEventFormatter build() {
            LinkedHashMap<String, Object> metaData = this.metaData == null ? Collections.emptyMap() : new LinkedHashMap<String, Object>(this.metaData);
            String timestampKey = this.timestampKey == null ? "timestamp" : this.timestampKey;
            DateTimeFormatter formatter = this.formatter == null ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : this.formatter;
            ZoneId zoneId = this.zoneId == null ? ZoneId.systemDefault() : this.zoneId;
            return new JsonEventFormatter(metaData, timestampKey, formatter.withZone(zoneId), this.includeTimestamp);
        }
    }
}

