/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.InstanceProvider;
import org.jboss.wsf.stack.cxf.CXFInstanceProvider;
import org.jboss.wsf.stack.cxf.client.ProviderImpl;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSBusFactory;
import org.jboss.wsf.stack.cxf.deployment.aspect.SecurityActions;

public final class CXFInstanceProviderDeploymentAspect
extends AbstractDeploymentAspect {
    public void start(Deployment dep) {
        for (org.jboss.wsf.spi.deployment.Endpoint ep : dep.getService().getEndpoints()) {
            Object serviceBean = ep.getAttachment(Object.class);
            Endpoint cxfEp = (Endpoint)ep.getAttachment(Endpoint.class);
            ep.setInstanceProvider((InstanceProvider)new CXFInstanceProvider(serviceBean, cxfEp));
        }
        this.setUserEndpointBus(dep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserEndpointBus(Deployment dep) {
        ClassLoader clientClassLoader = ProviderImpl.class.getClassLoader();
        if (BusFactory.getDefaultBus((boolean)false) == null) {
            JBossWSBusFactory.getDefaultBus((ClassLoader)clientClassLoader);
        }
        ClassLoader cl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader((ClassLoader)CXFInstanceProviderDeploymentAspect.createDelegateClassLoader(clientClassLoader, dep.getClassLoader()));
            Bus userBus = BusFactory.newInstance().createBus();
            for (org.jboss.wsf.spi.deployment.Endpoint ep : dep.getService().getEndpoints()) {
                ep.addAttachment(Bus.class, (Object)userBus);
            }
        }
        finally {
            SecurityActions.setContextClassLoader(cl);
        }
    }

    private static DelegateClassLoader createDelegateClassLoader(final ClassLoader clientClassLoader, final ClassLoader origClassLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return new DelegateClassLoader(clientClassLoader, origClassLoader);
        }
        return AccessController.doPrivileged(new PrivilegedAction<DelegateClassLoader>(){

            @Override
            public DelegateClassLoader run() {
                return new DelegateClassLoader(clientClassLoader, origClassLoader);
            }
        });
    }
}

