/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jboss.weld.bootstrap.BeanDeploymentArchiveMapping;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.events.AbstractAnnotatedTypeRegisteringEvent;
import org.jboss.weld.bootstrap.events.configurator.AnnotatedTypeConfiguratorImpl;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.literal.InterceptorBindingTypeLiteral;
import org.jboss.weld.literal.NormalScopeLiteral;
import org.jboss.weld.literal.QualifierLiteral;
import org.jboss.weld.literal.ScopeLiteral;
import org.jboss.weld.literal.StereotypeLiteral;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.util.annotated.AnnotatedTypeWrapper;

public class BeforeBeanDiscoveryImpl
extends AbstractAnnotatedTypeRegisteringEvent
implements BeforeBeanDiscovery {
    protected final List<AnnotatedTypeConfiguratorImpl<? extends Annotation>> additionalQualifiers = new LinkedList<AnnotatedTypeConfiguratorImpl<? extends Annotation>>();
    protected final List<AnnotatedTypeConfiguratorImpl<? extends Annotation>> additionalInterceptorBindings = new LinkedList<AnnotatedTypeConfiguratorImpl<? extends Annotation>>();

    public static void fire(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        BeforeBeanDiscoveryImpl event = new BeforeBeanDiscoveryImpl(beanManager, deployment, bdaMapping, contexts);
        event.fire();
        event.finish();
    }

    protected BeforeBeanDiscoveryImpl(BeanManagerImpl beanManager, Deployment deployment, BeanDeploymentArchiveMapping bdaMapping, Collection<ContextHolder<? extends Context>> contexts) {
        super(beanManager, (Type)((Object)BeforeBeanDiscovery.class), bdaMapping, deployment, contexts);
    }

    public void addQualifier(Class<? extends Annotation> bindingType) {
        this.checkWithinObserverNotification();
        this.getTypeStore().add(bindingType, (Annotation)QualifierLiteral.INSTANCE);
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(bindingType);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(bindingType);
        BootstrapLogger.LOG.addQualifierCalled(this.getReceiver(), bindingType);
    }

    public void addInterceptorBinding(Class<? extends Annotation> bindingType, Annotation ... bindingTypeDef) {
        this.checkWithinObserverNotification();
        TypeStore typeStore = this.getTypeStore();
        typeStore.add(bindingType, (Annotation)InterceptorBindingTypeLiteral.INSTANCE);
        for (Annotation a : bindingTypeDef) {
            typeStore.add(bindingType, a);
        }
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(bindingType);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(bindingType);
        BootstrapLogger.LOG.addInterceptorBindingCalled(this.getReceiver(), bindingType);
    }

    public void addScope(Class<? extends Annotation> scopeType, boolean normal, boolean passivating) {
        this.checkWithinObserverNotification();
        if (normal) {
            this.getTypeStore().add(scopeType, (Annotation)((Object)new NormalScopeLiteral(passivating)));
        } else {
            if (passivating) {
                throw BootstrapLogger.LOG.passivatingNonNormalScopeIllegal(scopeType);
            }
            this.getTypeStore().add(scopeType, (Annotation)ScopeLiteral.INSTANCE);
        }
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(scopeType);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(scopeType);
        ((ReflectionCache)this.getBeanManager().getServices().get(ReflectionCache.class)).cleanup();
        BootstrapLogger.LOG.addScopeCalled(this.getReceiver(), scopeType);
    }

    public void addStereotype(Class<? extends Annotation> stereotype, Annotation ... stereotypeDef) {
        this.checkWithinObserverNotification();
        TypeStore typeStore = this.getTypeStore();
        typeStore.add(stereotype, (Annotation)StereotypeLiteral.INSTANCE);
        for (Annotation a : stereotypeDef) {
            typeStore.add(stereotype, a);
        }
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).clearAnnotationData(stereotype);
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(stereotype);
        BootstrapLogger.LOG.addStereoTypeCalled(this.getReceiver(), stereotype);
    }

    public void addAnnotatedType(AnnotatedType<?> source) {
        this.checkWithinObserverNotification();
        BootstrapLogger.LOG.deprecatedAddAnnotatedTypeMethodUsed(source.getJavaClass());
        this.addAnnotatedType(source, null);
    }

    public void addAnnotatedType(AnnotatedType<?> type, String id) {
        this.checkWithinObserverNotification();
        this.addSyntheticAnnotatedType(type, id);
        BootstrapLogger.LOG.addAnnotatedTypeCalledInBBD(this.getReceiver(), type);
    }

    public <T> AnnotatedTypeConfigurator<T> addAnnotatedType(Class<T> type, String id) {
        this.checkWithinObserverNotification();
        AnnotatedTypeConfiguratorImpl<T> configurator = new AnnotatedTypeConfiguratorImpl<T>(this.getBeanManager().createAnnotatedType(type));
        this.additionalAnnotatedTypes.add(new AbstractAnnotatedTypeRegisteringEvent.AnnotatedTypeRegistration<T>(configurator, id));
        BootstrapLogger.LOG.addAnnotatedTypeCalledInBBD(this.getReceiver(), type);
        return configurator;
    }

    public void addQualifier(AnnotatedType<? extends Annotation> qualifier) {
        this.checkWithinObserverNotification();
        this.addSyntheticAnnotation(qualifier, (Annotation)QualifierLiteral.INSTANCE);
        BootstrapLogger.LOG.addQualifierCalled(this.getReceiver(), qualifier);
    }

    public void addInterceptorBinding(AnnotatedType<? extends Annotation> bindingType) {
        this.checkWithinObserverNotification();
        this.addSyntheticAnnotation(bindingType, (Annotation)InterceptorBindingTypeLiteral.INSTANCE);
        BootstrapLogger.LOG.addInterceptorBindingCalled(this.getReceiver(), bindingType);
    }

    public <T extends Annotation> AnnotatedTypeConfigurator<T> configureQualifier(Class<T> qualifier) {
        this.checkWithinObserverNotification();
        AnnotatedTypeConfiguratorImpl<T> configurator = new AnnotatedTypeConfiguratorImpl<T>(this.getBeanManager().createAnnotatedType(qualifier));
        this.additionalQualifiers.add(configurator);
        BootstrapLogger.LOG.configureQualifierCalled(this.getReceiver(), qualifier);
        return configurator;
    }

    public <T extends Annotation> AnnotatedTypeConfigurator<T> configureInterceptorBinding(Class<T> bindingType) {
        this.checkWithinObserverNotification();
        AnnotatedTypeConfiguratorImpl<T> configurator = new AnnotatedTypeConfiguratorImpl<T>(this.getBeanManager().createAnnotatedType(bindingType));
        this.additionalInterceptorBindings.add(configurator);
        BootstrapLogger.LOG.configureInterceptorBindingCalled(this.getReceiver(), bindingType);
        return configurator;
    }

    @Override
    protected void finish() {
        super.finish();
        try {
            for (AnnotatedTypeConfiguratorImpl<? extends Annotation> qualifierAsAnnotatedType : this.additionalQualifiers) {
                this.addSyntheticAnnotation(qualifierAsAnnotatedType.complete(), (Annotation)QualifierLiteral.INSTANCE);
            }
            for (AnnotatedTypeConfiguratorImpl<? extends Annotation> interceptorBindingAsAnnotatedType : this.additionalInterceptorBindings) {
                this.addSyntheticAnnotation(interceptorBindingAsAnnotatedType.complete(), (Annotation)InterceptorBindingTypeLiteral.INSTANCE);
            }
        }
        catch (Exception e) {
            throw new DefinitionException((Throwable)e);
        }
    }

    private <A extends Annotation> void addSyntheticAnnotation(AnnotatedType<A> annotation, Annotation requiredMetaAnnotation) {
        if (requiredMetaAnnotation != null && !annotation.isAnnotationPresent(requiredMetaAnnotation.annotationType())) {
            annotation = new AnnotatedTypeWrapper<A>(annotation, requiredMetaAnnotation);
        }
        ((ClassTransformer)this.getBeanManager().getServices().get(ClassTransformer.class)).addSyntheticAnnotation(annotation, this.getBeanManager().getId());
        ((MetaAnnotationStore)this.getBeanManager().getServices().get(MetaAnnotationStore.class)).clearAnnotationData(annotation.getJavaClass());
    }
}

