/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.spi.monitoring;

public class StatisticsAccumulator {
    protected double max = Double.MIN_VALUE;
    protected double min = Double.MAX_VALUE;
    private double sampleSum;
    private double sampleSquareSum;
    private long sampleCount;
    protected String unit;

    public void sample(double value) {
        ++this.sampleCount;
        if (value < this.min) {
            this.min = value;
        }
        if (value > this.max) {
            this.max = value;
        }
        this.sampleSum += value;
        this.sampleSquareSum += value * value;
    }

    public String getValue() {
        return this.toString();
    }

    public String toString() {
        return "Minimum Value = " + this.min + " " + this.unit + " Maximum Value = " + this.max + " " + this.unit + " Average Value = " + this.computeAverage() + " " + this.unit + " Standard Deviation = " + this.computeStandardDeviation() + " " + this.unit + " Samples Collected = " + this.sampleCount;
    }

    protected double computeAverage() {
        return this.sampleSum / (double)this.sampleCount;
    }

    protected double computeStandardDeviation() {
        double sampleSumSquare = this.sampleSum * this.sampleSum;
        return Math.sqrt((this.sampleSquareSum - sampleSumSquare / (double)this.sampleCount) / (double)(this.sampleCount - 1L));
    }

    public StatisticsAccumulator(String unit) {
        this.unit = unit;
        this.sampleCount = 0L;
        this.sampleSum = 0.0;
        this.sampleSquareSum = 0.0;
    }

    void clearState() {
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        this.sampleCount = 0L;
        this.sampleSum = 0.0;
        this.sampleSquareSum = 0.0;
    }

    public void unitTestValidate(String expectedUnit, double expectedMin, double expectedMax, long expectedSampleCount, double expectedAverage, double expectedStandardDeviation) {
        if (!expectedUnit.equals(this.unit)) {
            throw new RuntimeException("Unit is not same as expected Unit\nUnit = " + this.unit + "ExpectedUnit = " + expectedUnit);
        }
        if (this.min != expectedMin) {
            throw new RuntimeException("Minimum value is not same as expected minimum value\nMin Value = " + this.min + "Expected Min Value = " + expectedMin);
        }
        if (this.max != expectedMax) {
            throw new RuntimeException("Maximum value is not same as expected maximum value\nMax Value = " + this.max + "Expected Max Value = " + expectedMax);
        }
        if (this.sampleCount != expectedSampleCount) {
            throw new RuntimeException("Sample count is not same as expected Sample Count\nSampleCount = " + this.sampleCount + "Expected Sample Count = " + expectedSampleCount);
        }
        if (this.computeAverage() != expectedAverage) {
            throw new RuntimeException("Average is not same as expected Average\nAverage = " + this.computeAverage() + "Expected Average = " + expectedAverage);
        }
        double difference = Math.abs(this.computeStandardDeviation() - expectedStandardDeviation);
        if (difference > 1.0) {
            throw new RuntimeException("Standard Deviation is not same as expected Std Deviation\nStandard Dev = " + this.computeStandardDeviation() + "Expected Standard Dev = " + expectedStandardDeviation);
        }
    }
}

