/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.transformer;

import java.io.File;
import java.util.ConcurrentModificationException;
import org.wildfly.extras.transformer.ArchiveTransformer;

public abstract class TransformerBuilder {
    private final Thread thread = Thread.currentThread();
    protected File configsDir;
    protected Boolean verbose;
    private boolean built;

    protected TransformerBuilder() {
    }

    public final TransformerBuilder setConfigsDir(String configsDir) {
        if (this.thread != Thread.currentThread()) {
            throw new ConcurrentModificationException("Builder instance used by multiple threads");
        }
        if (this.built) {
            throw new IllegalStateException("Builder instance have been already closed");
        }
        if (configsDir == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        if ("".equals(configsDir)) {
            throw new IllegalArgumentException("Parameter cannot be empty string");
        }
        File configsDirFile = new File(configsDir);
        if (!configsDirFile.exists()) {
            throw new IllegalArgumentException("Directory '" + configsDir + "' doesn't exist");
        }
        if (!configsDirFile.isDirectory()) {
            throw new IllegalArgumentException("Provided value '" + configsDir + "' is not directory");
        }
        this.configsDir = configsDirFile;
        return this;
    }

    public final TransformerBuilder setVerbose(boolean verbose) {
        if (this.thread != Thread.currentThread()) {
            throw new ConcurrentModificationException("Builder instance used by multiple threads");
        }
        if (this.built) {
            throw new IllegalStateException("Builder instance have been already closed");
        }
        if (this.verbose != null) {
            throw new IllegalStateException("This method can be called only once");
        }
        this.verbose = verbose;
        return this;
    }

    public final ArchiveTransformer build() {
        if (this.thread != Thread.currentThread()) {
            throw new ConcurrentModificationException("Builder instance used by multiple threads");
        }
        if (this.built) {
            throw new IllegalStateException("Builder instance have been already closed");
        }
        this.built = true;
        return this.buildInternal();
    }

    protected abstract ArchiveTransformer buildInternal();
}

