/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.transformer;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.wildfly.galleon.plugin.transformer.Utils;

class JarUtils {
    private static final Path MANIFEST_DIR = Paths.get("META-INF", new String[0]);
    private static final Path MANIFEST_FILE = MANIFEST_DIR.resolve("MANIFEST.MF");

    JarUtils() {
    }

    static boolean isSignedJar(Path jarFile) throws IOException {
        JarFile jar = new JarFile(jarFile.toFile());
        Manifest manifest = jar.getManifest();
        boolean signed = false;
        if (manifest != null) {
            block0: for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
                for (Object attrkey : entry.getValue().keySet()) {
                    if (!(attrkey instanceof Attributes.Name) || ((Attributes.Name)attrkey).toString().indexOf("-Digest") == -1) continue;
                    signed = true;
                    continue block0;
                }
            }
        }
        return signed;
    }

    static void unsign(Path jarFile) throws Exception {
        FileInputStream fi = new FileInputStream(jarFile.toFile());
        Path dir = Files.createTempDirectory("unsign-jar-" + jarFile.getFileName(), new FileAttribute[0]);
        Utils.unzip(fi, dir.toFile());
        JarUtils.visitJar(dir);
        fi.close();
        Files.delete(jarFile);
        Utils.zip(dir, jarFile);
        Utils.recursiveDelete(dir);
    }

    private static void visitJar(final Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path f = dir.relativize(file);
                if (MANIFEST_DIR.equals(f.getParent())) {
                    if (MANIFEST_FILE.equals(f)) {
                        JarUtils.transformManifest(file);
                    } else if (f.toString().endsWith(".SF") || f.toString().endsWith(".RSA") || f.toString().endsWith(".DSA")) {
                        Files.delete(file);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void transformManifest(Path manifestFile) throws IOException {
        FileInputStream fi = new FileInputStream(manifestFile.toFile());
        Manifest manifest2 = new Manifest();
        try {
            Manifest manifest = new Manifest(fi);
            for (Map.Entry<Object, Object> entry : manifest.getMainAttributes().entrySet()) {
                manifest2.getMainAttributes().put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : manifest.getEntries().entrySet()) {
                boolean toRemove = false;
                for (Object attrkey : ((Attributes)entry.getValue()).keySet()) {
                    if (!(attrkey instanceof Attributes.Name) || ((Attributes.Name)attrkey).toString().indexOf("-Digest") == -1) continue;
                    toRemove = true;
                    break;
                }
                if (toRemove) continue;
                manifest2.getEntries().put((String)entry.getKey(), (Attributes)entry.getValue());
            }
            return;
        }
        finally {
            fi.close();
            Files.delete(manifestFile);
            FileOutputStream out = new FileOutputStream(manifestFile.toFile());
            Object object = null;
            try {
                manifest2.write(out);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
    }
}

