/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.lang.invoke.MethodHandles;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiFunction;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.PeekableTouchableMap;
import org.infinispan.container.offheap.MemoryAddressHash;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.StripedLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OffHeapConcurrentMap
implements ConcurrentMap<WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>>,
PeekableTouchableMap<WrappedBytes, WrappedBytes>,
AutoCloseable {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    public static final int INITIAL_SIZE = 256;
    private static final int LOCK_COUNT = Math.min(Util.findNextHighestPowerOfTwo((int)ProcessorInfo.availableProcessors()) << 1, 256);
    private static final int MAX_ADDRESS_COUNT = Integer.MIN_VALUE;
    private static final int LOCK_SHIFT = 31 - Integer.numberOfTrailingZeros(LOCK_COUNT);
    private static final int LOCK_REGION_SHIFT = Integer.numberOfTrailingZeros(LOCK_COUNT);
    private final AtomicLong size = new AtomicLong();
    private final StripedLock locks;
    private final OffHeapMemoryAllocator allocator;
    private final OffHeapEntryFactory offHeapEntryFactory;
    private final EntryListener listener;
    @GuardedBy(value="locks#lockAll")
    private volatile int sizeThreshold;
    @GuardedBy(value="locks")
    private IntSet pendingBlocks;
    @GuardedBy(value="locks")
    private MemoryAddressHash memoryLookup;
    @GuardedBy(value="locks")
    private int memoryShift;
    @GuardedBy(value="locks")
    private MemoryAddressHash oldMemoryLookup;
    @GuardedBy(value="locks")
    private int oldMemoryShift;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffHeapConcurrentMap(OffHeapMemoryAllocator allocator, OffHeapEntryFactory offHeapEntryFactory, EntryListener listener) {
        this.allocator = Objects.requireNonNull(allocator);
        this.offHeapEntryFactory = Objects.requireNonNull(offHeapEntryFactory);
        this.listener = listener;
        this.locks = new StripedLock(LOCK_COUNT);
        this.locks.lockAll();
        try {
            if (!this.sizeMemoryBuckets(256)) {
                throw new IllegalArgumentException("Unable to initialize off heap addresses as memory eviction is too low!");
            }
        }
        finally {
            this.locks.unlockAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean touchKey(Object k, long currentTimeMillis) {
        if (!(k instanceof WrappedBytes)) {
            return false;
        }
        int hashCode = k.hashCode();
        int lockOffset = this.getLockOffset(hashCode);
        StampedLock stampedLock = this.locks.getLockWithOffset(lockOffset);
        long writeStamp = stampedLock.writeLock();
        try {
            this.checkDeallocation();
            MemoryAddressHash memoryLookup = this.pendingBlocks != null && this.pendingBlocks.contains(lockOffset) ? this.oldMemoryLookup : this.memoryLookup;
            boolean bl = this.lockedTouch(memoryLookup, (WrappedBytes)k, hashCode, currentTimeMillis);
            return bl;
        }
        finally {
            stampedLock.unlockWrite(writeStamp);
        }
    }

    @GuardedBy(value="locks#writeLock")
    private boolean lockedTouch(MemoryAddressHash memoryLookup, WrappedBytes k, int hashCode, long currentTimeMillis) {
        int memoryOffset = this.getMemoryOffset(memoryLookup, hashCode);
        long bucketAddress = memoryLookup.getMemoryAddressOffset(memoryOffset);
        if (bucketAddress == 0L) {
            return false;
        }
        long actualAddress = this.performGet(bucketAddress, k, hashCode);
        if (actualAddress != 0L) {
            long newAddress = this.offHeapEntryFactory.updateMaxIdle(actualAddress, currentTimeMillis);
            if (newAddress != 0L) {
                this.performPut(bucketAddress, actualAddress, newAddress, k, memoryOffset, false, false);
            } else {
                this.entryRetrieved(actualAddress);
            }
            return true;
        }
        return false;
    }

    @GuardedBy(value="locks#writeLock")
    private void entryCreated(long newAddress) {
        if (this.listener != null) {
            this.listener.entryCreated(newAddress);
        }
    }

    @GuardedBy(value="locks#writeLock")
    private void entryRemoved(long removedAddress) {
        if (this.listener != null) {
            this.listener.entryRemoved(removedAddress);
        }
        this.allocator.deallocate(removedAddress, this.offHeapEntryFactory.getSize(removedAddress, false));
    }

    @GuardedBy(value="locks#writeLock")
    private void entryReplaced(long newAddress, long oldAddress) {
        if (this.listener != null) {
            this.listener.entryReplaced(newAddress, oldAddress);
        }
        this.allocator.deallocate(oldAddress, this.offHeapEntryFactory.getSize(oldAddress, false));
    }

    @GuardedBy(value="locks#readLock")
    private void entryRetrieved(long entryAddress) {
        if (this.listener != null) {
            this.listener.entryRetrieved(entryAddress);
        }
    }

    private static int spread(int h) {
        return h * 1327217885 & Integer.MAX_VALUE;
    }

    @GuardedBy(value="locks#readLock")
    private int getMemoryOffset(int hashCode) {
        return this.getOffset(hashCode, this.memoryShift);
    }

    private int getOffset(int hashCode, int shift) {
        return OffHeapConcurrentMap.spread(hashCode) >>> shift;
    }

    @GuardedBy(value="locks#readLock")
    private int getMemoryOffset(MemoryAddressHash memoryLookup, int hashCode) {
        return this.getOffset(hashCode, memoryLookup == this.memoryLookup ? this.memoryShift : this.oldMemoryShift);
    }

    StampedLock getStampedLock(int hashCode) {
        return this.locks.getLockWithOffset(this.getLockOffset(hashCode));
    }

    private int getLockOffset(int hashCode) {
        return this.getOffset(hashCode, LOCK_SHIFT);
    }

    private int getBucketRegionSize(int bucketTotal) {
        return bucketTotal >>> LOCK_REGION_SHIFT;
    }

    private void checkDeallocation() {
        if (this.memoryLookup == null) {
            throw new IllegalStateException("Map was already shut down!");
        }
    }

    @GuardedBy(value="locks#lockAll")
    private boolean sizeMemoryBuckets(int bucketCount) {
        if (this.listener != null && !this.listener.resize(bucketCount)) {
            this.sizeThreshold = Integer.MAX_VALUE;
            return false;
        }
        this.sizeThreshold = OffHeapConcurrentMap.computeThreshold(bucketCount);
        this.oldMemoryLookup = this.memoryLookup;
        this.oldMemoryShift = this.memoryShift;
        this.memoryLookup = new MemoryAddressHash(bucketCount, this.allocator);
        this.memoryShift = 31 - Integer.numberOfTrailingZeros(bucketCount);
        return true;
    }

    static int computeThreshold(int bucketCount) {
        return bucketCount - (bucketCount >> 2);
    }

    StripedLock getLocks() {
        return this.locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResize() {
        IntSet localPendingBlocks;
        if (this.size.get() < (long)this.sizeThreshold || this.oldMemoryLookup != null) {
            return;
        }
        boolean onlyHelp = false;
        this.locks.lockAll();
        try {
            if (this.oldMemoryLookup != null) {
                onlyHelp = true;
                localPendingBlocks = this.pendingBlocks;
            } else {
                int newBucketCount = this.memoryLookup.getPointerCount() << 1;
                if (newBucketCount == Integer.MIN_VALUE) {
                    this.sizeThreshold = Integer.MAX_VALUE;
                }
                if (!this.sizeMemoryBuckets(newBucketCount)) {
                    return;
                }
                localPendingBlocks = IntSets.concurrentSet((int)LOCK_COUNT);
                for (int i = 0; i < LOCK_COUNT; ++i) {
                    localPendingBlocks.set(i);
                }
                this.pendingBlocks = localPendingBlocks;
            }
        }
        finally {
            this.locks.unlockAll();
        }
        this.helpCompleteTransfer(localPendingBlocks, true);
        if (!onlyHelp) {
            if (!localPendingBlocks.isEmpty()) {
                this.helpCompleteTransfer(localPendingBlocks, false);
                assert (localPendingBlocks.isEmpty());
            }
            this.locks.lockAll();
            try {
                if (this.pendingBlocks == null) {
                    return;
                }
                this.transferComplete();
            }
            finally {
                this.locks.unlockAll();
            }
        }
    }

    @GuardedBy(value="locks#lockAll")
    private void transferComplete() {
        MemoryAddressHash oldMemoryLookup = this.oldMemoryLookup;
        this.pendingBlocks = null;
        if (this.listener != null) {
            boolean resized = this.listener.resize(-oldMemoryLookup.getPointerCount());
            assert (resized) : "Resize of negative pointers should always work!";
        }
        this.oldMemoryLookup = null;
        oldMemoryLookup.deallocate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helpCompleteTransfer(IntSet pendingBlocks, boolean tryLock) {
        if (pendingBlocks != null) {
            PrimitiveIterator.OfInt iterator = pendingBlocks.iterator();
            while (iterator.hasNext()) {
                long stamp;
                int offset = iterator.nextInt();
                StampedLock lock = this.locks.getLockWithOffset(offset);
                if (tryLock) {
                    stamp = lock.tryWriteLock();
                    if (stamp == 0L) {
                        continue;
                    }
                } else {
                    stamp = lock.writeLock();
                }
                try {
                    if (!pendingBlocks.remove(offset)) continue;
                    this.transfer(offset);
                }
                finally {
                    lock.unlockWrite(stamp);
                }
            }
        }
    }

    @GuardedBy(value="locks#writeLock")
    private void ensureTransferred(int lockOffset) {
        if (this.pendingBlocks != null && this.pendingBlocks.remove(lockOffset)) {
            this.transfer(lockOffset);
        }
    }

    @GuardedBy(value="locks#writeLock")
    private void transfer(int lockOffset) {
        int pointerCount = this.oldMemoryLookup.getPointerCount();
        int blockSize = this.getBucketRegionSize(pointerCount);
        LongStream memoryLocations = this.oldMemoryLookup.removeAll(lockOffset * blockSize, blockSize);
        memoryLocations.forEach((long address) -> {
            while (address != 0L) {
                long nextAddress = this.offHeapEntryFactory.getNext(address);
                this.offHeapEntryFactory.setNext(address, 0L);
                int hashCode = this.offHeapEntryFactory.getHashCode(address);
                int memoryOffset = this.getMemoryOffset(hashCode);
                long newBucketAddress = this.memoryLookup.getMemoryAddressOffset(memoryOffset);
                this.performPut(newBucketAddress, address, address, null, memoryOffset, false, true);
                address = nextAddress;
            }
        });
    }

    @Override
    public void close() {
        this.locks.lockAll();
        try {
            this.actualClear();
            this.memoryLookup.deallocate();
            this.memoryLookup = null;
        }
        finally {
            this.locks.unlockAll();
        }
    }

    @Override
    public int size() {
        return (int)Math.min(this.size.get(), Integer.MAX_VALUE);
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> compute(WrappedBytes key, BiFunction<? super WrappedBytes, ? super InternalCacheEntry<WrappedBytes, WrappedBytes>, ? extends InternalCacheEntry<WrappedBytes, WrappedBytes>> remappingFunction) {
        InternalCacheEntry<WrappedBytes, WrappedBytes> result;
        InternalCacheEntry<WrappedBytes, WrappedBytes> prev;
        int hashCode = key.hashCode();
        int lockOffset = this.getLockOffset(hashCode);
        StampedLock stampedLock = this.locks.getLockWithOffset(lockOffset);
        long writeStamp = stampedLock.writeLock();
        try {
            this.checkDeallocation();
            this.ensureTransferred(lockOffset);
            int memoryOffset = this.getMemoryOffset(hashCode);
            long bucketAddress = this.memoryLookup.getMemoryAddressOffset(memoryOffset);
            long actualAddress = bucketAddress == 0L ? 0L : this.performGet(bucketAddress, key, hashCode);
            prev = actualAddress != 0L ? this.offHeapEntryFactory.fromMemory(actualAddress) : null;
            result = remappingFunction.apply((WrappedBytes)key, prev);
            if (prev == result) {
            } else if (result != null) {
                long newAddress = this.offHeapEntryFactory.create(key, hashCode, result);
                this.performPut(bucketAddress, actualAddress, newAddress, key, memoryOffset, false, false);
            } else {
                this.performRemove(bucketAddress, actualAddress, key, null, memoryOffset, false);
            }
        }
        finally {
            stampedLock.unlockWrite(writeStamp);
        }
        if (prev == null && result != null) {
            this.checkResize();
        }
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalCacheEntry<WrappedBytes, WrappedBytes> peekOrGet(WrappedBytes k, boolean peek) {
        int hashCode = k.hashCode();
        int lockOffset = this.getLockOffset(hashCode);
        StampedLock stampedLock = this.locks.getLockWithOffset(lockOffset);
        long readStamp = stampedLock.readLock();
        try {
            this.checkDeallocation();
            MemoryAddressHash memoryLookup = this.pendingBlocks != null && this.pendingBlocks.contains(lockOffset) ? this.oldMemoryLookup : this.memoryLookup;
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = this.lockedPeekOrGet(memoryLookup, k, hashCode, peek);
            return internalCacheEntry;
        }
        finally {
            stampedLock.unlockRead(readStamp);
        }
    }

    @GuardedBy(value="locks#readLock")
    private InternalCacheEntry<WrappedBytes, WrappedBytes> lockedPeekOrGet(MemoryAddressHash memoryLookup, WrappedBytes k, int hashCode, boolean peek) {
        long bucketAddress = memoryLookup.getMemoryAddressOffset(this.getMemoryOffset(memoryLookup, hashCode));
        if (bucketAddress == 0L) {
            return null;
        }
        long actualAddress = this.performGet(bucketAddress, k, hashCode);
        if (actualAddress != 0L) {
            InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(actualAddress);
            if (!peek) {
                this.entryRetrieved(actualAddress);
            }
            return ice;
        }
        return null;
    }

    @GuardedBy(value="locks#readLock")
    private long performGet(long bucketHeadAddress, WrappedBytes k, int hashCode) {
        long address = bucketHeadAddress;
        while (address != 0L) {
            long nextAddress = this.offHeapEntryFactory.getNext(address);
            if (this.offHeapEntryFactory.equalsKey(address, k, hashCode)) break;
            address = nextAddress;
        }
        return address;
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> get(Object key) {
        if (!(key instanceof WrappedBytes)) {
            return null;
        }
        return this.peekOrGet((WrappedBytes)key, false);
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> peek(Object key) {
        if (!(key instanceof WrappedBytes)) {
            return null;
        }
        return this.peekOrGet((WrappedBytes)key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> put(WrappedBytes key, InternalCacheEntry<WrappedBytes, WrappedBytes> value) {
        InternalCacheEntry<WrappedBytes, WrappedBytes> returnedValue;
        int hashCode = key.hashCode();
        int lockOffset = this.getLockOffset(hashCode);
        StampedLock stampedLock = this.locks.getLockWithOffset(lockOffset);
        long writeStamp = stampedLock.writeLock();
        try {
            this.checkDeallocation();
            this.ensureTransferred(lockOffset);
            int memoryOffset = this.getMemoryOffset(hashCode);
            long address = this.memoryLookup.getMemoryAddressOffset(memoryOffset);
            long newAddress = this.offHeapEntryFactory.create(key, hashCode, value);
            returnedValue = this.performPut(address, 0L, newAddress, key, memoryOffset, true, false);
        }
        finally {
            stampedLock.unlockWrite(writeStamp);
        }
        if (returnedValue == null) {
            this.checkResize();
        }
        return returnedValue;
    }

    @GuardedBy(value="locks#writeLock")
    private InternalCacheEntry<WrappedBytes, WrappedBytes> performPut(long bucketHeadAddress, long actualAddress, long newAddress, WrappedBytes key, int memoryOffset, boolean requireReturn, boolean transfer) {
        if (bucketHeadAddress == 0L) {
            this.memoryLookup.putMemoryAddressOffset(memoryOffset, newAddress);
            if (!transfer) {
                this.entryCreated(newAddress);
                this.size.incrementAndGet();
            }
            return null;
        }
        boolean replaceHead = false;
        boolean foundPrevious = false;
        InternalCacheEntry<WrappedBytes, WrappedBytes> previousValue = null;
        long address = bucketHeadAddress;
        long prevAddress = 0L;
        while (address != 0L) {
            long nextAddress = this.offHeapEntryFactory.getNext(address);
            if (!foundPrevious && (actualAddress == 0L ? this.offHeapEntryFactory.equalsKey(address, key) : actualAddress == address)) {
                assert (!transfer) : "We should never have a replace with put from a transfer!";
                foundPrevious = true;
                if (requireReturn) {
                    previousValue = this.offHeapEntryFactory.fromMemory(address);
                }
                this.entryReplaced(newAddress, address);
                if (prevAddress == 0L) {
                    if (nextAddress == 0L) {
                        replaceHead = true;
                    } else {
                        this.memoryLookup.putMemoryAddressOffset(memoryOffset, nextAddress);
                    }
                } else {
                    this.offHeapEntryFactory.setNext(prevAddress, nextAddress);
                    address = nextAddress;
                    continue;
                }
            }
            prevAddress = address;
            address = nextAddress;
        }
        if (!foundPrevious && !transfer) {
            this.entryCreated(newAddress);
            this.size.incrementAndGet();
        }
        if (replaceHead) {
            this.memoryLookup.putMemoryAddressOffset(memoryOffset, newAddress);
        } else {
            this.offHeapEntryFactory.setNext(prevAddress, newAddress);
        }
        return previousValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> remove(Object key) {
        if (!(key instanceof WrappedBytes)) {
            return null;
        }
        int hashCode = key.hashCode();
        int lockOffset = this.getLockOffset(hashCode);
        StampedLock stampedLock = this.locks.getLockWithOffset(lockOffset);
        long writeStamp = stampedLock.writeLock();
        try {
            this.checkDeallocation();
            this.ensureTransferred(lockOffset);
            int memoryOffset = this.getMemoryOffset(hashCode);
            long address = this.memoryLookup.getMemoryAddressOffset(memoryOffset);
            if (address == 0L) {
                InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = null;
                return internalCacheEntry;
            }
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = this.performRemove(address, 0L, (WrappedBytes)key, null, memoryOffset, true);
            return internalCacheEntry;
        }
        finally {
            stampedLock.unlockWrite(writeStamp);
        }
    }

    @GuardedBy(value="locks#writeLock")
    void remove(WrappedBytes key, long address) {
        int hashCode = key.hashCode();
        this.ensureTransferred(this.getLockOffset(hashCode));
        int memoryOffset = this.getMemoryOffset(hashCode);
        long bucketAddress = this.memoryLookup.getMemoryAddressOffset(memoryOffset);
        assert (bucketAddress != 0L);
        this.performRemove(bucketAddress, address, key, null, memoryOffset, false);
    }

    @GuardedBy(value="locks#writeLock")
    private InternalCacheEntry<WrappedBytes, WrappedBytes> performRemove(long bucketHeadAddress, long actualAddress, WrappedBytes key, WrappedBytes value, int memoryOffset, boolean requireReturn) {
        long prevAddress = 0L;
        long address = bucketHeadAddress;
        InternalCacheEntry<WrappedBytes, WrappedBytes> ice = null;
        while (address != 0L) {
            boolean removeThisAddress;
            long nextAddress = this.offHeapEntryFactory.getNext(address);
            boolean bl = actualAddress == 0L ? this.offHeapEntryFactory.equalsKey(address, key) : (removeThisAddress = actualAddress == address);
            if (removeThisAddress) {
                if (value != null && !value.equalsWrappedBytes((WrappedBytes)(ice = this.offHeapEntryFactory.fromMemory(address)).getValue())) {
                    ice = null;
                    break;
                }
                if (requireReturn && ice == null) {
                    ice = this.offHeapEntryFactory.fromMemory(address);
                }
                this.entryRemoved(address);
                if (prevAddress != 0L) {
                    this.offHeapEntryFactory.setNext(prevAddress, nextAddress);
                } else {
                    this.memoryLookup.putMemoryAddressOffset(memoryOffset, nextAddress);
                }
                this.size.decrementAndGet();
                break;
            }
            prevAddress = address;
            address = nextAddress;
        }
        return ice;
    }

    @Override
    public void putAll(Map<? extends WrappedBytes, ? extends InternalCacheEntry<WrappedBytes, WrappedBytes>> m) {
        for (Map.Entry<? extends WrappedBytes, ? extends InternalCacheEntry<WrappedBytes, WrappedBytes>> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.locks.lockAll();
        try {
            this.actualClear();
        }
        finally {
            this.locks.unlockAll();
        }
    }

    @GuardedBy(value="locks#lockAll")
    private void actualClear() {
        this.checkDeallocation();
        if (trace) {
            log.trace("Clearing off heap data");
        }
        LongConsumer removeEntries = address -> {
            while (address != 0L) {
                long nextAddress = this.offHeapEntryFactory.getNext(address);
                this.entryRemoved(address);
                address = nextAddress;
            }
        };
        int pointerCount = this.memoryLookup.getPointerCount();
        this.memoryLookup.removeAll().forEach(removeEntries);
        this.memoryLookup.deallocate();
        this.memoryLookup = null;
        if (this.listener != null) {
            boolean resized = this.listener.resize(-pointerCount);
            assert (resized) : "Resize of negative pointers should always work!";
        }
        if (this.oldMemoryLookup != null) {
            this.oldMemoryLookup.removeAll().forEach(removeEntries);
            this.transferComplete();
        }
        this.sizeMemoryBuckets(256);
        this.size.set(0L);
        if (trace) {
            log.trace("Cleared off heap data");
        }
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> putIfAbsent(WrappedBytes key, InternalCacheEntry<WrappedBytes, WrappedBytes> value) {
        return this.compute(key, (? super WrappedBytes k, ? super InternalCacheEntry<WrappedBytes, WrappedBytes> v) -> {
            if (v == null) {
                return value;
            }
            return v;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        if (!(key instanceof WrappedBytes) || !(value instanceof InternalCacheEntry)) {
            return false;
        }
        Object innerValue = ((InternalCacheEntry)value).getValue();
        if (!(innerValue instanceof WrappedBytes)) {
            return false;
        }
        int hashCode = key.hashCode();
        int lockOffset = this.getLockOffset(hashCode);
        StampedLock stampedLock = this.locks.getLockWithOffset(lockOffset);
        long writeStamp = stampedLock.writeLock();
        try {
            this.checkDeallocation();
            this.ensureTransferred(lockOffset);
            int memoryOffset = this.getMemoryOffset(hashCode);
            long address = this.memoryLookup.getMemoryAddressOffset(memoryOffset);
            boolean bl = address != 0L && this.performRemove(address, 0L, (WrappedBytes)key, (WrappedBytes)innerValue, memoryOffset, true) != null;
            return bl;
        }
        finally {
            stampedLock.unlockWrite(writeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(WrappedBytes key, InternalCacheEntry<WrappedBytes, WrappedBytes> oldValue, InternalCacheEntry<WrappedBytes, WrappedBytes> newValue) {
        int hashCode = key.hashCode();
        int lockOffset = this.getLockOffset(hashCode);
        StampedLock stampedLock = this.locks.getLockWithOffset(lockOffset);
        long writeStamp = stampedLock.writeLock();
        try {
            this.checkDeallocation();
            this.ensureTransferred(lockOffset);
            int memoryOffset = this.getMemoryOffset(hashCode);
            long address = this.memoryLookup.getMemoryAddressOffset(memoryOffset);
            boolean bl = address != 0L && this.performReplace(address, key, hashCode, memoryOffset, oldValue, newValue) != null;
            return bl;
        }
        finally {
            stampedLock.unlockWrite(writeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> replace(WrappedBytes key, InternalCacheEntry<WrappedBytes, WrappedBytes> value) {
        int hashCode = key.hashCode();
        int lockOffset = this.getLockOffset(hashCode);
        StampedLock stampedLock = this.locks.getLockWithOffset(lockOffset);
        long writeStamp = stampedLock.writeLock();
        try {
            this.checkDeallocation();
            this.ensureTransferred(lockOffset);
            int memoryOffset = this.getMemoryOffset(hashCode);
            long address = this.memoryLookup.getMemoryAddressOffset(memoryOffset);
            if (address == 0L) {
                InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = null;
                return internalCacheEntry;
            }
            InternalCacheEntry<WrappedBytes, WrappedBytes> internalCacheEntry = this.performReplace(address, key, hashCode, memoryOffset, null, value);
            return internalCacheEntry;
        }
        finally {
            stampedLock.unlockWrite(writeStamp);
        }
    }

    @GuardedBy(value="locks#writeLock")
    private InternalCacheEntry<WrappedBytes, WrappedBytes> performReplace(long bucketHeadAddress, WrappedBytes key, int hashCode, int memoryOffset, InternalCacheEntry<WrappedBytes, WrappedBytes> oldValue, InternalCacheEntry<WrappedBytes, WrappedBytes> newValue) {
        long prevAddress = 0L;
        long address = bucketHeadAddress;
        InternalCacheEntry<WrappedBytes, WrappedBytes> ice = null;
        while (address != 0L) {
            long nextAddress = this.offHeapEntryFactory.getNext(address);
            if (this.offHeapEntryFactory.equalsKey(address, key)) {
                if (oldValue != null && !((WrappedBytes)(ice = this.offHeapEntryFactory.fromMemory(address)).getValue()).equalsWrappedBytes((WrappedBytes)oldValue.getValue())) {
                    ice = null;
                    break;
                }
                if (ice == null) {
                    ice = this.offHeapEntryFactory.fromMemory(address);
                }
                long newAddress = this.offHeapEntryFactory.create(key, hashCode, newValue);
                this.entryReplaced(newAddress, address);
                if (prevAddress != 0L) {
                    this.offHeapEntryFactory.setNext(prevAddress, newAddress);
                } else {
                    this.memoryLookup.putMemoryAddressOffset(memoryOffset, newAddress);
                }
                this.offHeapEntryFactory.setNext(newAddress, nextAddress);
                break;
            }
            prevAddress = address;
            address = nextAddress;
        }
        return ice;
    }

    @Override
    public Set<WrappedBytes> keySet() {
        throw new UnsupportedOperationException("keySet is not supported as it doesn't contain expiration data");
    }

    @Override
    public Collection<InternalCacheEntry<WrappedBytes, WrappedBytes>> values() {
        return new AbstractCollection<InternalCacheEntry<WrappedBytes, WrappedBytes>>(){

            @Override
            public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iterator() {
                return OffHeapConcurrentMap.this.entryIterator();
            }

            @Override
            public int size() {
                return OffHeapConcurrentMap.this.size();
            }

            @Override
            public boolean remove(Object o) {
                return o instanceof InternalCacheEntry && OffHeapConcurrentMap.this.remove(((InternalCacheEntry)o).getKey(), ((InternalCacheEntry)o).getValue());
            }
        };
    }

    private Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> entryIterator() {
        if (this.size.get() == 0L) {
            return Collections.emptyIterator();
        }
        return new ValueIterator();
    }

    @Override
    public Set<Map.Entry<WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>>> entrySet() {
        return new AbstractSet<Map.Entry<WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>>>(){

            @Override
            public Iterator<Map.Entry<WrappedBytes, InternalCacheEntry<WrappedBytes, WrappedBytes>>> iterator() {
                Iterator entryIterator = OffHeapConcurrentMap.this.entryIterator();
                return new IteratorMapper(entryIterator, ice -> new AbstractMap.SimpleImmutableEntry<WrappedBytes, InternalCacheEntry>((WrappedBytes)ice.getKey(), (InternalCacheEntry)ice));
            }

            @Override
            public int size() {
                return OffHeapConcurrentMap.this.size();
            }
        };
    }

    private class ValueIterator
    implements Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> {
        int bucketPosition;
        int bucketCount = -1;
        int bucketLockShift;
        int bucketLockStop;
        Queue<InternalCacheEntry<WrappedBytes, WrappedBytes>> values = new ArrayDeque<InternalCacheEntry<WrappedBytes, WrappedBytes>>();

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.values.isEmpty()) {
                return true;
            }
            this.checkAndReadBucket();
            return !this.values.isEmpty();
        }

        private void checkAndReadBucket() {
            while (this.bucketPosition != this.bucketCount && !this.readNextBucket()) {
            }
        }

        @Override
        public InternalCacheEntry<WrappedBytes, WrappedBytes> next() {
            InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.values.poll();
            if (ice == null) {
                this.checkAndReadBucket();
                ice = this.values.remove();
            }
            return ice;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean readNextBucket() {
            boolean foundValue = false;
            int lockOffset = this.getLockOffset(this.bucketPosition);
            StampedLock stampedLock = OffHeapConcurrentMap.this.locks.getLockWithOffset(lockOffset);
            long readStamp = stampedLock.readLock();
            try {
                boolean completedLockBucket;
                OffHeapConcurrentMap.this.checkDeallocation();
                MemoryAddressHash memoryAddressHash = OffHeapConcurrentMap.this.pendingBlocks != null && OffHeapConcurrentMap.this.pendingBlocks.contains(lockOffset) ? OffHeapConcurrentMap.this.oldMemoryLookup : OffHeapConcurrentMap.this.memoryLookup;
                int pointerCount = memoryAddressHash.getPointerCount();
                if (this.bucketCount == -1) {
                    this.bucketCount = pointerCount;
                    this.bucketLockStop = OffHeapConcurrentMap.this.getBucketRegionSize(this.bucketCount);
                    this.bucketLockShift = Integer.numberOfTrailingZeros(this.bucketLockStop);
                } else {
                    if (this.bucketCount > pointerCount) {
                        this.bucketPosition = this.bucketCount;
                        boolean bl = false;
                        return bl;
                    }
                    if (this.bucketCount < pointerCount) {
                        this.resizeIteration(pointerCount);
                    }
                }
                while (!(completedLockBucket = this.bucketLockStop == this.bucketPosition)) {
                    long nextAddress;
                    long address;
                    if ((address = memoryAddressHash.getMemoryAddressOffsetNoTraceIfAbsent(this.bucketPosition++)) == 0L) continue;
                    do {
                        nextAddress = OffHeapConcurrentMap.this.offHeapEntryFactory.getNext(address);
                        this.values.add(OffHeapConcurrentMap.this.offHeapEntryFactory.fromMemory(address));
                        foundValue = true;
                    } while ((address = nextAddress) != 0L);
                    break;
                }
                if (completedLockBucket && this.bucketPosition != this.bucketCount) {
                    this.bucketLockStop += OffHeapConcurrentMap.this.getBucketRegionSize(this.bucketCount);
                }
            }
            finally {
                stampedLock.unlockRead(readStamp);
            }
            return foundValue;
        }

        @GuardedBy(value="locks#readLock")
        private void resizeIteration(int newBucketSize) {
            int bucketIncreaseShift = 31 - Integer.numberOfTrailingZeros(this.bucketCount) - OffHeapConcurrentMap.this.memoryShift;
            this.bucketPosition <<= bucketIncreaseShift;
            this.bucketLockStop <<= bucketIncreaseShift;
            this.bucketLockShift = Integer.numberOfTrailingZeros(this.bucketLockStop);
            this.bucketCount = newBucketSize;
        }

        private int getLockOffset(int bucketPosition) {
            return bucketPosition >>> this.bucketLockShift;
        }
    }

    public static interface EntryListener {
        public boolean resize(int var1);

        public void entryCreated(long var1);

        public void entryRemoved(long var1);

        public void entryReplaced(long var1, long var3);

        public void entryRetrieved(long var1);
    }
}

