/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.commons.util.Experimental;
import org.infinispan.functional.MetaParam;

@NotThreadSafe
@Experimental
public final class MetaParams
implements Iterable<MetaParam<?>> {
    static final MetaParam<?>[] EMPTY_ARRAY = new MetaParam[0];
    private MetaParam<?>[] metas;
    private int length;

    MetaParams(MetaParam<?>[] metas, int length) {
        this.metas = metas;
        this.length = length;
        assert (this.checkLength());
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int size() {
        return this.length;
    }

    public MetaParams copy() {
        if (this.length == 0) {
            return MetaParams.empty();
        }
        return new MetaParams(Arrays.copyOf(this.metas, this.metas.length), this.length);
    }

    public <T extends MetaParam> Optional<T> find(Class<T> type) {
        return Optional.ofNullable(this.findNullable(type));
    }

    private <T extends MetaParam> T findNullable(Class<T> type) {
        for (MetaParam<?> meta : this.metas) {
            if (meta == null || !meta.getClass().isAssignableFrom(type)) continue;
            return (T)meta;
        }
        return null;
    }

    public void add(MetaParam meta) {
        assert (meta != null);
        if (this.metas.length == 0) {
            this.metas = new MetaParam[]{meta};
            this.length = 1;
        } else {
            int hole = -1;
            for (int i = 0; i < this.metas.length; ++i) {
                MetaParam<?> m = this.metas[i];
                if (m == null) {
                    hole = i;
                    continue;
                }
                if (!m.getClass().isAssignableFrom(meta.getClass())) continue;
                this.metas[i] = meta;
                assert (this.checkLength());
                return;
            }
            ++this.length;
            if (hole < 0) {
                MetaParam<?>[] newMetas = Arrays.copyOf(this.metas, this.metas.length + 1);
                newMetas[newMetas.length - 1] = meta;
                this.metas = newMetas;
            } else {
                this.metas[hole] = meta;
            }
            assert (this.checkLength());
        }
    }

    private boolean checkLength() {
        int l = 0;
        for (MetaParam<?> meta : this.metas) {
            if (meta == null) continue;
            ++l;
        }
        return l == this.length;
    }

    public void addMany(MetaParam ... metaParams) {
        if (this.metas.length == 0) {
            this.metas = metaParams.getClass().getComponentType() == MetaParam.class ? metaParams : (MetaParam[])Arrays.copyOf(metaParams, metaParams.length, MetaParam[].class);
            this.length = (int)Stream.of(this.metas).filter(Objects::nonNull).count();
        } else {
            ArrayList notFound = new ArrayList(metaParams.length);
            for (MetaParam metaParam : metaParams) {
                this.updateExisting(metaParam, notFound);
            }
            if (!notFound.isEmpty()) {
                MetaParam<?>[] newMetas = Arrays.copyOf(this.metas, this.metas.length + notFound.size());
                int i = this.metas.length;
                for (MetaParam metaParam : notFound) {
                    newMetas[i++] = metaParam;
                }
                this.metas = newMetas;
            }
        }
        assert (this.checkLength());
    }

    private void updateExisting(MetaParam newMeta, List<MetaParam<?>> notFound) {
        int hole = -1;
        for (int i = 0; i < this.metas.length; ++i) {
            MetaParam<?> m = this.metas[i];
            if (m == null) {
                hole = i;
                continue;
            }
            if (!m.getClass().isAssignableFrom(newMeta.getClass())) continue;
            this.metas[i] = newMeta;
            return;
        }
        ++this.length;
        if (hole < 0) {
            notFound.add(newMeta);
        } else {
            this.metas[hole] = newMeta;
        }
    }

    public <T extends MetaParam> void remove(Class<T> type) {
        for (int i = 0; i < this.metas.length; ++i) {
            MetaParam<?> m = this.metas[i];
            if (m == null || !m.getClass().isAssignableFrom(type)) continue;
            this.metas[i] = null;
            --this.length;
            assert (this.checkLength());
            return;
        }
    }

    public <T extends MetaParam> void replace(Class<T> type, Function<T, T> f) {
        int hole = -1;
        for (int i = 0; i < this.metas.length; ++i) {
            MetaParam<?> m = this.metas[i];
            if (m == null) {
                hole = i;
                continue;
            }
            if (!m.getClass().isAssignableFrom(type)) continue;
            MetaParam newMeta = (MetaParam)f.apply(m);
            assert (newMeta == null || type.isInstance(newMeta));
            if (newMeta == null) {
                --this.length;
            }
            this.metas[i] = newMeta;
            assert (this.checkLength());
            return;
        }
        MetaParam newMeta = (MetaParam)f.apply(null);
        if (newMeta == null) {
            assert (this.checkLength());
            return;
        }
        if (hole < 0) {
            ++this.length;
            MetaParam<?>[] newMetas = Arrays.copyOf(this.metas, this.metas.length + 1);
            newMetas[newMetas.length - 1] = newMeta;
            this.metas = newMetas;
        } else {
            ++this.length;
            this.metas[hole] = newMeta;
        }
        assert (this.checkLength());
    }

    public String toString() {
        return "MetaParams{length=" + this.length + ", metas=" + Arrays.toString(this.metas) + '}';
    }

    static MetaParams of(MetaParam ... metas) {
        metas = MetaParams.filterDuplicates(metas);
        return new MetaParams(metas, metas.length);
    }

    static MetaParams of(MetaParam meta) {
        assert (meta != null);
        return new MetaParams(new MetaParam[]{meta}, 1);
    }

    static MetaParams empty() {
        return new MetaParams(EMPTY_ARRAY, 0);
    }

    private static MetaParam[] filterDuplicates(MetaParam ... metas) {
        HashMap all = new HashMap();
        for (MetaParam meta : metas) {
            if (meta == null) continue;
            all.put(meta.getClass(), meta);
        }
        return all.values().toArray(new MetaParam[all.size()]);
    }

    void merge(MetaParams other) {
        HashMap all = new HashMap();
        for (MetaParam<?> meta : other.metas) {
            if (meta == null) continue;
            all.put(meta.getClass(), meta);
        }
        for (MetaParam<?> meta : this.metas) {
            if (meta == null) continue;
            all.put(meta.getClass(), meta);
        }
        this.metas = all.values().toArray(new MetaParam[all.size()]);
    }

    @Override
    public Iterator<MetaParam<?>> iterator() {
        return new It();
    }

    @Override
    public Spliterator<MetaParam<?>> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length, 257);
    }

    public static MetaParams readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        int length = input.readInt();
        MetaParam[] metas = new MetaParam[length];
        for (int i = 0; i < length; ++i) {
            metas[i] = (MetaParam)input.readObject();
        }
        return new MetaParams(metas, metas.length);
    }

    public static void writeTo(ObjectOutput output, MetaParams params) throws IOException {
        output.writeInt(params.size());
        for (MetaParam<?> meta : params) {
            output.writeObject(meta);
        }
    }

    private class It
    implements Iterator<MetaParam<?>> {
        private int i = 0;

        public It() {
            this.skipNulls();
        }

        private void skipNulls() {
            while (this.i < MetaParams.this.metas.length && MetaParams.this.metas[this.i] == null) {
                ++this.i;
            }
        }

        @Override
        public boolean hasNext() {
            return this.i < MetaParams.this.metas.length;
        }

        @Override
        public MetaParam<?> next() {
            if (this.i >= MetaParams.this.metas.length) {
                throw new NoSuchElementException();
            }
            MetaParam meta = MetaParams.this.metas[this.i++];
            this.skipNulls();
            return meta;
        }
    }
}

