/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.Ownership;
import org.infinispan.interceptors.impl.AbstractIracRemoteSiteInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTxIracRemoteSiteInterceptor
extends AbstractIracRemoteSiteInterceptor {
    private static final Log log = LogFactory.getLog(NonTxIracRemoteSiteInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
        return this.visitDataWriteCommand(ctx, command);
    }

    @Override
    boolean isTraceEnabled() {
        return trace;
    }

    @Override
    Log getLog() {
        return log;
    }

    private Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        Object key = command.getKey();
        if (NonTxIracRemoteSiteInterceptor.isNormalWriteCommand(command)) {
            return this.invokeNext(ctx, command);
        }
        Ownership ownership = this.getOwnership(key);
        switch (ownership) {
            case PRIMARY: {
                return this.invokeNextThenAccept(ctx, command, this::validateOnPrimary);
            }
            case BACKUP: {
                if (ctx.isOriginLocal()) break;
                return this.invokeNextThenAccept(ctx, command, this::setIracMetadataForOwner);
            }
        }
        return this.invokeNext(ctx, command);
    }
}

