/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import jakarta.transaction.Transaction;
import java.lang.invoke.MethodHandles;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.persistence.Store;
import org.infinispan.commons.reactive.RxJavaInterop;
import org.infinispan.commons.util.IntSet;
import org.infinispan.persistence.spi.AdvancedCacheExpirationWriter;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.FlagAffectedStore;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.persistence.spi.TransactionalCacheWriter;
import org.infinispan.persistence.support.BatchModification;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class NonBlockingStoreAdapter<K, V>
implements NonBlockingStore<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    private static final AtomicInteger id = trace ? new AtomicInteger() : null;
    private final Lifecycle oldStoreImpl;
    private final Set<NonBlockingStore.Characteristic> characteristics;
    private BlockingManager blockingManager;
    private MarshallableEntryFactory<K, V> marshallableEntryFactory;

    public NonBlockingStoreAdapter(Lifecycle oldStoreImpl) {
        this.oldStoreImpl = oldStoreImpl;
        this.characteristics = NonBlockingStoreAdapter.determineCharacteristics(oldStoreImpl);
    }

    public Lifecycle getActualStore() {
        return this.oldStoreImpl;
    }

    private static String nextTraceId(String operationName) {
        return id != null ? "StoreAdapter-" + operationName + "-" + id.getAndIncrement() : null;
    }

    private static Set<NonBlockingStore.Characteristic> determineCharacteristics(Object storeImpl) {
        EnumSet<NonBlockingStore.Characteristic> characteristics;
        if (storeImpl instanceof SegmentedAdvancedLoadWriteStore) {
            characteristics = EnumSet.of(NonBlockingStore.Characteristic.SEGMENTABLE, NonBlockingStore.Characteristic.EXPIRATION, NonBlockingStore.Characteristic.BULK_READ);
        } else {
            characteristics = EnumSet.noneOf(NonBlockingStore.Characteristic.class);
            if (storeImpl instanceof AdvancedCacheLoader) {
                characteristics.add(NonBlockingStore.Characteristic.BULK_READ);
            } else if (!(storeImpl instanceof CacheLoader)) {
                characteristics.add(NonBlockingStore.Characteristic.WRITE_ONLY);
            }
            if (storeImpl instanceof AdvancedCacheWriter) {
                characteristics.add(NonBlockingStore.Characteristic.EXPIRATION);
            } else if (!(storeImpl instanceof CacheWriter)) {
                characteristics.add(NonBlockingStore.Characteristic.READ_ONLY);
            }
        }
        Store storeAnnotation = storeImpl.getClass().getAnnotation(Store.class);
        if (storeAnnotation != null && storeAnnotation.shared()) {
            characteristics.add(NonBlockingStore.Characteristic.SHAREABLE);
        }
        if (storeImpl instanceof TransactionalCacheWriter) {
            characteristics.add(NonBlockingStore.Characteristic.TRANSACTIONAL);
        }
        return characteristics;
    }

    @Override
    public CompletionStage<Void> start(InitializationContext ctx) {
        this.blockingManager = ctx.getBlockingManager();
        this.marshallableEntryFactory = ctx.getMarshallableEntryFactory();
        return this.blockingManager.runBlocking(() -> {
            if (this.isReadOnly()) {
                this.loader().init(ctx);
            } else {
                this.writer().init(ctx);
            }
            this.oldStoreImpl.start();
        }, NonBlockingStoreAdapter.nextTraceId("start"));
    }

    @Override
    public CompletionStage<Void> stop() {
        return this.blockingManager.runBlocking(() -> ((Lifecycle)this.oldStoreImpl).stop(), NonBlockingStoreAdapter.nextTraceId("stop"));
    }

    @Override
    public Set<NonBlockingStore.Characteristic> characteristics() {
        return this.characteristics;
    }

    @Override
    public CompletionStage<Long> size(IntSet segments) {
        return this.blockingManager.supplyBlocking(() -> this.isSegmented() ? this.segmentedStore().size(segments) : this.advancedLoader().size(), NonBlockingStoreAdapter.nextTraceId("size")).thenApply(Integer::longValue);
    }

    @Override
    public CompletionStage<Long> approximateSize(IntSet segments) {
        return this.size(segments);
    }

    @Override
    public Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean includeValues) {
        Publisher<MarshallableEntry<? super K, V>> publisher = this.isSegmented() ? this.segmentedStore().entryPublisher(segments, filter, includeValues, true) : this.advancedLoader().entryPublisher(filter, includeValues, true);
        return this.blockingManager.blockingPublisher(publisher);
    }

    @Override
    public Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter) {
        Publisher<? super K> publisher = this.isSegmented() ? this.segmentedStore().publishKeys(segments, filter) : this.advancedLoader().publishKeys(filter);
        return this.blockingManager.blockingPublisher(publisher);
    }

    @Override
    public Publisher<MarshallableEntry<K, V>> purgeExpired() {
        return Flowable.defer(() -> {
            UnicastProcessor flowableProcessor = UnicastProcessor.create();
            AdvancedCacheExpirationWriter.ExpirationPurgeListener expirationPurgeListener = new AdvancedCacheExpirationWriter.ExpirationPurgeListener<K, V>((FlowableProcessor)flowableProcessor){
                final /* synthetic */ FlowableProcessor val$flowableProcessor;
                {
                    this.val$flowableProcessor = flowableProcessor;
                }

                @Override
                public void marshalledEntryPurged(MarshallableEntry<K, V> entry) {
                    this.val$flowableProcessor.onNext(entry);
                }

                @Override
                public void entryPurged(K key) {
                    this.val$flowableProcessor.onNext(NonBlockingStoreAdapter.this.marshallableEntryFactory.create(key));
                }
            };
            AdvancedCacheWriter advancedCacheWriter = this.advancedWriter();
            CompletionStage<Void> purgeStage = advancedCacheWriter instanceof AdvancedCacheExpirationWriter ? this.blockingManager.runBlocking(() -> ((AdvancedCacheExpirationWriter)advancedCacheWriter).purge(Runnable::run, expirationPurgeListener), NonBlockingStoreAdapter.nextTraceId("purgeExpired")) : this.blockingManager.runBlocking(() -> advancedCacheWriter.purge(Runnable::run, expirationPurgeListener), NonBlockingStoreAdapter.nextTraceId("purgeExpired"));
            purgeStage.whenComplete((arg_0, arg_1) -> NonBlockingStoreAdapter.lambda$purgeExpired$4((FlowableProcessor)flowableProcessor, arg_0, arg_1));
            return flowableProcessor;
        });
    }

    @Override
    public CompletionStage<Boolean> isAvailable() {
        return this.blockingManager.supplyBlocking(() -> this.isReadOnly() ? this.loader().isAvailable() : this.writer().isAvailable(), NonBlockingStoreAdapter.nextTraceId("isAvailable"));
    }

    @Override
    public CompletionStage<MarshallableEntry<K, V>> load(int segment, Object key) {
        return this.blockingManager.supplyBlocking(() -> this.isSegmented() ? this.segmentedStore().get(segment, key) : this.loader().loadEntry(key), NonBlockingStoreAdapter.nextTraceId("load"));
    }

    @Override
    public CompletionStage<Boolean> containsKey(int segment, Object key) {
        return this.blockingManager.supplyBlocking(() -> this.isSegmented() ? this.segmentedStore().contains(segment, key) : this.loader().contains(key), NonBlockingStoreAdapter.nextTraceId("containsKey"));
    }

    @Override
    public CompletionStage<Void> write(int segment, MarshallableEntry<? extends K, ? extends V> entry) {
        return this.blockingManager.runBlocking(() -> {
            if (this.isSegmented()) {
                this.segmentedStore().write(segment, entry);
            } else {
                this.writer().write(entry);
            }
        }, NonBlockingStoreAdapter.nextTraceId("write"));
    }

    @Override
    public CompletionStage<Boolean> delete(int segment, Object key) {
        return this.blockingManager.supplyBlocking(() -> this.isSegmented() ? this.segmentedStore().delete(segment, key) : this.writer().delete(key), NonBlockingStoreAdapter.nextTraceId("delete"));
    }

    @Override
    public CompletionStage<Void> addSegments(IntSet segments) {
        return this.blockingManager.runBlocking(() -> this.segmentedStore().addSegments(segments), NonBlockingStoreAdapter.nextTraceId("addSegments"));
    }

    @Override
    public CompletionStage<Void> removeSegments(IntSet segments) {
        return this.blockingManager.runBlocking(() -> this.segmentedStore().removeSegments(segments), NonBlockingStoreAdapter.nextTraceId("removeSegments"));
    }

    @Override
    public CompletionStage<Void> clear() {
        if (this.oldStoreImpl instanceof AdvancedCacheWriter) {
            return this.blockingManager.runBlocking(this.advancedWriter()::clear, NonBlockingStoreAdapter.nextTraceId("clear"));
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> batch(int publisherCount, Publisher<NonBlockingStore.SegmentedPublisher<Object>> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        Flowable objectFlowable = Flowable.fromPublisher(removePublisher).flatMap(RxJavaInterop.identityFunction(), false, publisherCount);
        Flowable meFlowable = Flowable.fromPublisher(writePublisher).flatMap(RxJavaInterop.identityFunction(), false, publisherCount);
        return this.blockingManager.supplyBlocking(() -> {
            Single objectSingle = objectFlowable.collect(Collectors.toSet());
            objectSingle.subscribe(this.writer()::deleteBatch);
            return this.writer().bulkUpdate((Publisher<MarshallableEntry<K, V>>)meFlowable);
        }, NonBlockingStoreAdapter.nextTraceId("batch-update")).thenCompose(Function.identity());
    }

    @Override
    public CompletionStage<Void> prepareWithModifications(Transaction transaction, int publisherCount, Publisher<NonBlockingStore.SegmentedPublisher<Object>> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) {
        HashSet<Object> affectedKeys = new HashSet<Object>();
        BatchModification oldBatchModification = new BatchModification(affectedKeys);
        Flowable.fromPublisher(removePublisher).subscribe(sp -> Flowable.fromPublisher((Publisher)sp).subscribe(key -> {
            affectedKeys.add(key);
            oldBatchModification.removeEntry(key);
        }));
        Flowable.fromPublisher(writePublisher).subscribe(sp -> Flowable.fromPublisher((Publisher)sp).subscribe(me -> {
            Object key = me.getKey();
            affectedKeys.add(key);
            oldBatchModification.addMarshalledEntry(key, (MarshallableEntry<Object, Object>)me);
        }));
        return this.blockingManager.runBlocking(() -> this.transactionalStore().prepareWithModifications(transaction, oldBatchModification), NonBlockingStoreAdapter.nextTraceId("prepareWithModifications"));
    }

    @Override
    public CompletionStage<Void> commit(Transaction transaction) {
        return this.blockingManager.runBlocking(() -> this.transactionalStore().commit(transaction), NonBlockingStoreAdapter.nextTraceId("commit"));
    }

    @Override
    public CompletionStage<Void> rollback(Transaction transaction) {
        return this.blockingManager.runBlocking(() -> this.transactionalStore().rollback(transaction), NonBlockingStoreAdapter.nextTraceId("rollback"));
    }

    @Override
    public boolean ignoreCommandWithFlags(long commandFlags) {
        if (this.oldStoreImpl instanceof FlagAffectedStore) {
            return !((FlagAffectedStore)this.oldStoreImpl).shouldWrite(commandFlags);
        }
        return false;
    }

    boolean isSegmented() {
        return this.characteristics.contains((Object)NonBlockingStore.Characteristic.SEGMENTABLE);
    }

    boolean isReadOnly() {
        return this.characteristics.contains((Object)NonBlockingStore.Characteristic.READ_ONLY);
    }

    public TransactionalCacheWriter<K, V> transactionalStore() {
        return (TransactionalCacheWriter)this.oldStoreImpl;
    }

    public SegmentedAdvancedLoadWriteStore<K, V> segmentedStore() {
        return (SegmentedAdvancedLoadWriteStore)this.oldStoreImpl;
    }

    public AdvancedCacheLoader<K, V> advancedLoader() {
        return (AdvancedCacheLoader)this.oldStoreImpl;
    }

    public AdvancedCacheWriter<K, V> advancedWriter() {
        return (AdvancedCacheWriter)this.oldStoreImpl;
    }

    public CacheLoader<K, V> loader() {
        return (CacheLoader)this.oldStoreImpl;
    }

    public CacheWriter<K, V> writer() {
        return (CacheWriter)this.oldStoreImpl;
    }

    private static /* synthetic */ void lambda$purgeExpired$4(FlowableProcessor flowableProcessor, Void ignore, Throwable t) {
        if (t != null) {
            flowableProcessor.onError(t);
        } else {
            flowableProcessor.onComplete();
        }
    }
}

