/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.saaj;

import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPConstants;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.w3c.dom.Element;

public final class SAAJUtils {
    private SAAJUtils() {
    }

    public static SOAPHeader getHeader(SOAPMessage m) throws SOAPException {
        try {
            return m.getSOAPHeader();
        }
        catch (UnsupportedOperationException ex) {
            return m.getSOAPPart().getEnvelope().getHeader();
        }
    }

    public static SOAPBody getBody(SOAPMessage m) throws SOAPException {
        try {
            return m.getSOAPBody();
        }
        catch (UnsupportedOperationException ex) {
            return m.getSOAPPart().getEnvelope().getBody();
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static void setFaultCode(SOAPFault f, QName code) throws SOAPException {
        if (f.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
            try {
                f.setFaultCode(code);
            }
            catch (SOAPException ex) {
                f.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                f.appendFaultSubcode(code);
            }
        } else {
            try {
                f.setFaultCode(code);
            }
            catch (Throwable t) {
                int count = 1;
                String pfx = "fc1";
                while (!StringUtils.isEmpty((String)f.getNamespaceURI(pfx))) {
                    pfx = "fc" + ++count;
                }
                if (code.getNamespaceURI() != null && !"".equals(code.getNamespaceURI())) {
                    f.addNamespaceDeclaration(pfx, code.getNamespaceURI());
                } else {
                    f.addNamespaceDeclaration(pfx, f.getNamespaceURI());
                }
                f.setFaultCode(pfx + ":" + code.getLocalPart());
            }
        }
    }

    public static Element adjustPrefix(Element e, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        try {
            String s = e.getPrefix();
            if (!prefix.equals(s)) {
                e.setPrefix(prefix);
                if (e instanceof SOAPElement) {
                    ((SOAPElement)e).removeNamespaceDeclaration(s);
                } else if (e.getClass().getName().equals("com.sun.org.apache.xerces.internal.dom.ElementNSImpl")) {
                    try {
                        Method method = e.getClass().getMethod("removeAttribute", String.class);
                        method.invoke((Object)e, "xmlns:" + s);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return e;
    }
}

