/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.jboss.resteasy.microprofile.client.RestClientDelegateBean;

public class RestClientExtension
implements Extension {
    private Set<RestClientData> proxyTypes = new LinkedHashSet<RestClientData>();
    private Set<Throwable> errors = new LinkedHashSet<Throwable>();
    private static BeanManager manager;

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        manager = beanManager;
    }

    public void registerRestClient(@Observes @WithAnnotations(value={RegisterRestClient.class}) ProcessAnnotatedType<?> type) {
        Class javaClass = type.getAnnotatedType().getJavaClass();
        if (javaClass.isInterface()) {
            RegisterRestClient annotation = (RegisterRestClient)type.getAnnotatedType().getAnnotation(RegisterRestClient.class);
            Optional<String> maybeUri = this.extractBaseUri(annotation);
            Optional<String> maybeConfigKey = this.extractConfigKey(annotation);
            this.proxyTypes.add(new RestClientData(javaClass, maybeUri, maybeConfigKey));
            type.veto();
        } else {
            this.errors.add(new IllegalArgumentException("Rest client needs to be an interface " + javaClass));
        }
    }

    private Optional<String> extractBaseUri(RegisterRestClient annotation) {
        String baseUri = annotation.baseUri();
        return Optional.ofNullable("".equals(baseUri) ? null : baseUri);
    }

    private Optional<String> extractConfigKey(RegisterRestClient annotation) {
        String configKey = annotation.configKey();
        return Optional.ofNullable("".equals(configKey) ? null : configKey);
    }

    public void createProxy(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (RestClientData clientData : this.proxyTypes) {
            afterBeanDiscovery.addBean((Bean)new RestClientDelegateBean(clientData.javaClass, beanManager, clientData.baseUri, clientData.configKey));
        }
    }

    public void reportErrors(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        for (Throwable error : this.errors) {
            afterDeploymentValidation.addDeploymentProblem(error);
        }
    }

    public static boolean isCDIActive() {
        return manager != null;
    }

    public static Object construct(Class<?> clazz) {
        Bean bean;
        HashSet beans = manager.getBeans(clazz, new Annotation[0]);
        if (beans.size() == 0) {
            return null;
        }
        if (beans.size() > 1) {
            HashSet modifiableBeans = new HashSet();
            modifiableBeans.addAll(beans);
            Iterator iterator = modifiableBeans.iterator();
            while (iterator.hasNext()) {
                Bean bean2 = (Bean)iterator.next();
                if (bean2.getBeanClass().equals(clazz) || bean2.isAlternative()) continue;
                iterator.remove();
            }
            beans = modifiableBeans;
        }
        if ((bean = manager.resolve((Set)beans)) == null) {
            return null;
        }
        CreationalContext context = manager.createCreationalContext((Contextual)bean);
        if (context == null) {
            return null;
        }
        return manager.getReference(bean, clazz, context);
    }

    private static class RestClientData {
        private final Class<?> javaClass;
        private final Optional<String> baseUri;
        private final Optional<String> configKey;

        private RestClientData(Class<?> javaClass, Optional<String> baseUri, Optional<String> configKey) {
            this.javaClass = javaClass;
            this.baseUri = baseUri;
            this.configKey = configKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RestClientData that = (RestClientData)o;
            return this.javaClass.equals(that.javaClass);
        }

        public int hashCode() {
            return Objects.hash(this.javaClass);
        }
    }
}

