/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.store;

import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.wildfly.common.Assert;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.SimpleName;
import org.wildfly.naming.client.util.FastHashtable;

public class RelativeContext
extends AbstractContext {
    private final AbstractContext rootContext;
    private final SimpleName prefix;

    public RelativeContext(FastHashtable<String, Object> environment, AbstractContext rootContext, SimpleName prefix) {
        super(environment);
        Assert.checkNotNullParam((String)"rootContext", (Object)rootContext);
        Assert.checkNotNullParam((String)"prefix", (Object)prefix);
        this.rootContext = rootContext;
        this.prefix = prefix;
    }

    @Override
    protected Object lookupNative(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new RelativeContext(new FastHashtable<String, Object>(this.getEnvironment()), this.rootContext, this.prefix);
        }
        return this.rootContext.lookup(this.getAbsoluteName(name));
    }

    @Override
    protected void bindNative(Name name, Object obj) throws NamingException {
        this.rootContext.bind(this.getAbsoluteName(name), obj);
    }

    @Override
    protected void rebindNative(Name name, Object obj) throws NamingException {
        this.rootContext.rebind(this.getAbsoluteName(name), obj);
    }

    @Override
    protected void unbindNative(Name name) throws NamingException {
        this.rootContext.unbind(this.getAbsoluteName(name));
    }

    @Override
    protected void renameNative(Name oldName, Name newName) throws NamingException {
        this.rootContext.rename(this.getAbsoluteName(oldName), this.getAbsoluteName(newName));
    }

    @Override
    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        return this.rootContext.list(this.getAbsoluteName(name));
    }

    @Override
    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        return this.rootContext.listBindings(this.getAbsoluteName(name));
    }

    @Override
    protected void destroySubcontextNative(Name name) throws NamingException {
        this.rootContext.destroySubcontext(this.getAbsoluteName(name));
    }

    @Override
    protected Context createSubcontextNative(Name name) throws NamingException {
        return this.rootContext.createSubcontext(this.getAbsoluteName(name));
    }

    @Override
    protected Object lookupLinkNative(Name name) throws NamingException {
        return this.rootContext.lookupLink(this.getAbsoluteName(name));
    }

    @Override
    public void close() {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.prefix.toString();
    }

    @Override
    public NameParser getNativeNameParser() {
        return this.rootContext.getNativeNameParser();
    }

    private SimpleName getAbsoluteName(Name suffix) {
        return this.prefix.clone().addAll(suffix);
    }
}

