/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.runner;

import java.io.IOException;
import java.util.Arrays;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentModification;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.ModificationCondition;
import org.jboss.as.patching.runner.PatchContentLoader;
import org.jboss.as.patching.runner.PatchingTask;
import org.jboss.as.patching.runner.PatchingTaskContext;
import org.jboss.as.patching.runner.PatchingTaskDescription;

abstract class AbstractPatchingTask<T extends ContentItem>
implements PatchingTask {
    protected final T contentItem;
    protected final PatchingTaskDescription description;
    private boolean ignoreApply;
    private boolean skipExecution;
    protected byte[] backupHash = IoUtils.NO_CONTENT;

    AbstractPatchingTask(PatchingTaskDescription description, Class<T> expected) {
        this.description = description;
        this.contentItem = description.getContentItem(expected);
    }

    public T getContentItem() {
        return this.contentItem;
    }

    @Override
    public boolean isRelevant(PatchingTaskContext context) throws PatchingException {
        ModificationCondition condition = this.description.getModification().getCondition();
        if (condition == null) {
            return true;
        }
        return condition.isSatisfied(context);
    }

    abstract byte[] backup(PatchingTaskContext var1) throws IOException;

    abstract byte[] apply(PatchingTaskContext var1, PatchContentLoader var2) throws IOException;

    abstract ContentModification createRollbackEntry(ContentModification var1, byte[] var2, byte[] var3);

    protected boolean failOnContentMismatch(PatchingTaskContext context) {
        return context.getCurrentMode() != PatchingTaskContext.Mode.UNDO;
    }

    protected ContentModification getOriginalModification(byte[] targetHash, byte[] itemHash) {
        return this.description.getModification();
    }

    protected void setIgnoreApply() {
        this.ignoreApply = true;
    }

    @Override
    public boolean prepare(PatchingTaskContext context) throws IOException {
        this.backupHash = this.backup(context);
        byte[] contentHash = ((ContentItem)this.contentItem).getContentHash();
        if (Arrays.equals(this.backupHash, contentHash)) {
            this.skipExecution = ((ContentItem)this.contentItem).getContentType() == ContentType.MISC && this.backupHash != IoUtils.NO_CONTENT;
            return true;
        }
        byte[] expected = this.description.getModification().getTargetHash();
        if (Arrays.equals(this.backupHash, expected)) {
            return !this.description.hasConflicts();
        }
        return false;
    }

    @Override
    public void execute(PatchingTaskContext context) throws IOException {
        if (this.ignoreApply) {
            return;
        }
        PatchContentLoader contentLoader = this.description.getLoader();
        boolean skip = this.skipExecution | context.isExcluded((ContentItem)this.contentItem);
        byte[] contentHash = skip ? this.backupHash : this.apply(context, contentLoader);
        ContentModification original = this.getOriginalModification(contentHash, this.backupHash);
        ContentModification rollbackAction = this.createRollbackEntry(original, contentHash, this.backupHash);
        context.recordChange(original, rollbackAction);
        if (!Arrays.equals(contentHash, ((ContentItem)this.contentItem).getContentHash()) && this.failOnContentMismatch(context) && !context.isIgnored((ContentItem)this.contentItem)) {
            throw PatchLogger.ROOT_LOGGER.wrongCopiedContent((ContentItem)this.contentItem);
        }
    }
}

