/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.util.FacesLogger;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExceptionHandlerWrapper;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.PartialResponseWriter;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.SystemEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AjaxExceptionHandlerImpl
extends ExceptionHandlerWrapper {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private static final String LOG_BEFORE_KEY = "jsf.context.exception.handler.log_before";
    private static final String LOG_AFTER_KEY = "jsf.context.exception.handler.log_after";
    private static final String LOG_KEY = "jsf.context.exception.handler.log";
    private LinkedList<ExceptionQueuedEvent> unhandledExceptions;
    private LinkedList<ExceptionQueuedEvent> handledExceptions;
    private ExceptionQueuedEvent handled;

    public AjaxExceptionHandlerImpl(ExceptionHandler handler) {
        super(handler);
    }

    public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
        return this.handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws FacesException {
        Iterator<ExceptionQueuedEvent> i = this.getUnhandledExceptionQueuedEvents().iterator();
        while (i.hasNext()) {
            ExceptionQueuedEvent event = i.next();
            ExceptionQueuedEventContext context = (ExceptionQueuedEventContext)event.getSource();
            try {
                Throwable t = context.getException();
                if (this.isRethrown(t)) {
                    this.handled = event;
                    Throwable unwrapped = this.getRootCause(t);
                    if (unwrapped != null) {
                        this.handlePartialResponseError(context.getContext(), unwrapped);
                        continue;
                    }
                    if (t instanceof FacesException) {
                        this.handlePartialResponseError(context.getContext(), t);
                        continue;
                    }
                    this.handlePartialResponseError(context.getContext(), new FacesException(t.getMessage(), t));
                    continue;
                }
                this.log(context);
            }
            finally {
                if (this.handledExceptions == null) {
                    this.handledExceptions = new LinkedList();
                }
                this.handledExceptions.add(event);
                i.remove();
            }
        }
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event != null) {
            if (this.unhandledExceptions == null) {
                this.unhandledExceptions = new LinkedList();
            }
            this.unhandledExceptions.add((ExceptionQueuedEvent)event);
        }
    }

    public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
        return this.unhandledExceptions != null ? this.unhandledExceptions : Collections.emptyList();
    }

    public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
        return this.handledExceptions != null ? this.handledExceptions : Collections.emptyList();
    }

    private void handlePartialResponseError(FacesContext context, Throwable t) {
        block4: {
            if (context.getResponseComplete()) {
                return;
            }
            try {
                ExternalContext extContext = context.getExternalContext();
                extContext.setResponseContentType("text/xml");
                extContext.addResponseHeader("Cache-Control", "no-cache");
                PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
                writer.startDocument();
                writer.startError(t.getClass().toString());
                String msg = context.isProjectStage(ProjectStage.Production) ? "See your server log for more information" : (t.getCause() != null ? t.getCause().getMessage() : t.getMessage());
                writer.write(msg != null ? msg : "");
                writer.endError();
                writer.endDocument();
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    LOGGER.log(Level.SEVERE, sw.toString());
                }
                context.responseComplete();
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, ioe.toString(), ioe);
            }
        }
    }

    private boolean isRethrown(Throwable t) {
        return !(t instanceof AbortProcessingException);
    }

    private void log(ExceptionQueuedEventContext exceptionContext) {
        UIComponent c = exceptionContext.getComponent();
        boolean beforePhase = exceptionContext.inBeforePhase();
        boolean afterPhase = exceptionContext.inAfterPhase();
        PhaseId phaseId = exceptionContext.getPhaseId();
        Throwable t = exceptionContext.getException();
        String key = this.getLoggingKey(beforePhase, afterPhase);
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, key, new Object[]{t.getClass().getName(), phaseId.toString(), c != null ? c.getClientId(exceptionContext.getContext()) : "", t.getMessage()});
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    private String getLoggingKey(boolean beforePhase, boolean afterPhase) {
        if (beforePhase) {
            return LOG_BEFORE_KEY;
        }
        if (afterPhase) {
            return LOG_AFTER_KEY;
        }
        return LOG_KEY;
    }
}

