/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.cluster.ha.BackupPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.SharedStoreBackupActivation;

public class SharedStoreSlavePolicy
extends BackupPolicy {
    private boolean failoverOnServerShutdown = ActiveMQDefaultConfiguration.isDefaultFailoverOnServerShutdown();
    private boolean allowAutoFailBack = ActiveMQDefaultConfiguration.isDefaultAllowAutoFailback();
    private boolean isWaitForActivation = ActiveMQDefaultConfiguration.isDefaultWaitForActivation();
    private SharedStoreMasterPolicy sharedStoreMasterPolicy;

    public SharedStoreSlavePolicy() {
    }

    public SharedStoreSlavePolicy(boolean failoverOnServerShutdown, boolean restartBackup, boolean allowAutoFailBack, ScaleDownPolicy scaleDownPolicy) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
        this.restartBackup = restartBackup;
        this.allowAutoFailBack = allowAutoFailBack;
        this.scaleDownPolicy = scaleDownPolicy;
    }

    @Deprecated
    public long getFailbackDelay() {
        return -1L;
    }

    @Deprecated
    public void setFailbackDelay(long failbackDelay) {
    }

    public boolean isFailoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        this.failoverOnServerShutdown = failoverOnServerShutdown;
    }

    public SharedStoreMasterPolicy getSharedStoreMasterPolicy() {
        if (this.sharedStoreMasterPolicy == null) {
            this.sharedStoreMasterPolicy = new SharedStoreMasterPolicy(this.failoverOnServerShutdown, this.isWaitForActivation);
        }
        return this.sharedStoreMasterPolicy;
    }

    public void setSharedStoreMasterPolicy(SharedStoreMasterPolicy sharedStoreMasterPolicy) {
        this.sharedStoreMasterPolicy = sharedStoreMasterPolicy;
    }

    @Override
    public boolean isSharedStore() {
        return true;
    }

    @Override
    public boolean canScaleDown() {
        return this.scaleDownPolicy != null;
    }

    public boolean isAllowAutoFailBack() {
        return this.allowAutoFailBack;
    }

    public void setAllowAutoFailBack(boolean allowAutoFailBack) {
        this.allowAutoFailBack = allowAutoFailBack;
    }

    public void setIsWaitForActivation(boolean isWaitForActivation) {
        this.isWaitForActivation = isWaitForActivation;
    }

    @Override
    public Activation createActivation(ActiveMQServerImpl server, boolean wasLive, Map<String, Object> activationParams, IOCriticalErrorListener ioCriticalErrorListener) {
        return new SharedStoreBackupActivation(server, this, ioCriticalErrorListener);
    }

    @Override
    public String getBackupGroupName() {
        return null;
    }
}

