/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.paging.cursor.PagedReference;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.jboss.logging.Logger;

public class RefsOperation
extends TransactionOperationAbstract {
    private static final Logger logger = Logger.getLogger(RefsOperation.class);
    private final AckReason reason;
    private final StorageManager storageManager;
    private Queue queue;
    List<MessageReference> refsToAck = new ArrayList<MessageReference>();
    List<MessageReference> pagedMessagesToPostACK = null;
    protected boolean ignoreRedeliveryCheck = false;
    private String lingerSessionId = null;

    public RefsOperation(Queue queue, AckReason reason, StorageManager storageManager) {
        this.queue = queue;
        this.reason = reason;
        this.storageManager = storageManager;
    }

    public void setIgnoreRedeliveryCheck() {
        this.ignoreRedeliveryCheck = true;
    }

    synchronized void addOnlyRefAck(MessageReference ref) {
        this.refsToAck.add(ref);
    }

    synchronized void addAck(MessageReference ref) {
        this.refsToAck.add(ref);
        if (ref.isPaged()) {
            if (this.pagedMessagesToPostACK == null) {
                this.pagedMessagesToPostACK = new ArrayList<MessageReference>();
            }
            this.pagedMessagesToPostACK.add(ref);
            ((PagedReference)ref).addPendingFlag();
        }
    }

    @Override
    public void afterRollback(Transaction tx) {
        this.afterRollback(tx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterRollback(Transaction tx, boolean sorted) {
        HashMap<QueueImpl, LinkedList<MessageReference>> queueMap = new HashMap<QueueImpl, LinkedList<MessageReference>>();
        long timeBase = System.currentTimeMillis();
        ArrayList<MessageReference> ackedRefs = new ArrayList<MessageReference>();
        for (MessageReference messageReference : this.refsToAck) {
            this.clearLingerRef(messageReference);
            messageReference.emptyConsumerID();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("rolling back " + messageReference));
            }
            try {
                if (messageReference.isAlreadyAcked()) {
                    ackedRefs.add(messageReference);
                }
                this.rollbackRedelivery(tx, messageReference, timeBase, queueMap);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorCheckingDLQ(e);
            }
        }
        for (Map.Entry entry : queueMap.entrySet()) {
            QueueImpl queue;
            LinkedList refs = (LinkedList)entry.getValue();
            QueueImpl queueImpl = queue = (QueueImpl)entry.getKey();
            synchronized (queueImpl) {
                queue.postRollback(refs, sorted);
            }
        }
        if (!ackedRefs.isEmpty()) {
            try {
                TransactionImpl ackedTX = new TransactionImpl(this.storageManager);
                for (MessageReference ref : ackedRefs) {
                    Message message = ref.getMessage();
                    if (message.isDurable()) {
                        int durableRefCount = ref.getQueue().durableUp(ref.getMessage());
                        if (durableRefCount == 1) {
                            this.storageManager.storeMessageTransactional(ackedTX.getID(), message);
                        }
                        this.storageManager.storeReferenceTransactional(ackedTX.getID(), this.queue.getID(), message.getMessageID());
                        ackedTX.setContainsPersistent();
                    }
                    ref.getQueue().refUp(ref);
                }
                ackedTX.commit(true);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.failedToProcessMessageReferenceAfterRollback(e);
            }
        }
        if (this.pagedMessagesToPostACK != null) {
            for (MessageReference messageReference : this.pagedMessagesToPostACK) {
                ((PagedReference)messageReference).removePendingFlag();
            }
        }
    }

    protected void rollbackRedelivery(Transaction tx, MessageReference ref, long timeBase, Map<QueueImpl, LinkedList<MessageReference>> queueMap) throws Exception {
        if (((Boolean)ref.getQueue().checkRedelivery(ref, timeBase, this.ignoreRedeliveryCheck).getA()).booleanValue()) {
            LinkedList<MessageReference> toCancel = queueMap.get(ref.getQueue());
            if (toCancel == null) {
                toCancel = new LinkedList();
                queueMap.put((QueueImpl)ref.getQueue(), toCancel);
            }
            toCancel.addFirst(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCommit(Transaction tx) {
        for (MessageReference ref : this.refsToAck) {
            this.clearLingerRef(ref);
            Queue queue = ref.getQueue();
            synchronized (queue) {
                ref.getQueue().postAcknowledge(ref, this.reason);
            }
        }
        if (this.pagedMessagesToPostACK != null) {
            for (MessageReference refmsg : this.pagedMessagesToPostACK) {
                ((PagedReference)refmsg).removePendingFlag();
                if (!((PagedReference)refmsg).isLargeMessage()) continue;
                refmsg.getQueue().refDown(refmsg);
            }
        }
    }

    private void clearLingerRef(MessageReference ref) {
        if (!ref.hasConsumerId() && this.lingerSessionId != null) {
            ref.getQueue().removeLingerSession(this.lingerSessionId);
        }
    }

    @Override
    public synchronized List<MessageReference> getRelatedMessageReferences() {
        LinkedList<MessageReference> listRet = new LinkedList<MessageReference>();
        if (this.refsToAck != null && !this.refsToAck.isEmpty()) {
            listRet.addAll(this.refsToAck);
        }
        return listRet;
    }

    @Override
    public synchronized List<MessageReference> getListOnConsumer(long consumerID) {
        LinkedList<MessageReference> list = new LinkedList<MessageReference>();
        for (MessageReference ref : this.refsToAck) {
            if (!ref.hasConsumerId() || ref.getConsumerId() != consumerID) continue;
            list.add(ref);
        }
        return list;
    }

    public List<MessageReference> getReferencesToAcknowledge() {
        return this.refsToAck;
    }

    public synchronized List<MessageReference> getLingerMessages() {
        LinkedList<MessageReference> list = new LinkedList<MessageReference>();
        for (MessageReference ref : this.refsToAck) {
            if (ref.hasConsumerId() || this.lingerSessionId == null) continue;
            list.add(ref);
        }
        return list;
    }

    public void setLingerSession(String lingerSessionId) {
        this.lingerSessionId = lingerSessionId;
    }
}

