/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools;

import java.util.Objects;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;

public abstract class EntityTools {
    public static boolean entitiesEqual(SessionImplementor session, String entityName, Object obj1, Object obj2) {
        Object id1 = EntityTools.getIdentifier(session, entityName, obj1);
        Object id2 = EntityTools.getIdentifier(session, entityName, obj2);
        return Objects.deepEquals(id1, id2);
    }

    public static Object getIdentifier(SessionImplementor session, String entityName, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)obj;
            return hibernateProxy.getHibernateLazyInitializer().getIdentifier();
        }
        return session.getEntityPersister(entityName, obj).getIdentifier(obj, (SharedSessionContractImplementor)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getTargetFromProxy(SessionFactoryImplementor sessionFactoryImplementor, HibernateProxy proxy) {
        if (!proxy.getHibernateLazyInitializer().isUninitialized() || EntityTools.activeProxySession(proxy)) {
            return proxy.getHibernateLazyInitializer().getImplementation();
        }
        SharedSessionContractImplementor sessionImplementor = proxy.getHibernateLazyInitializer().getSession();
        try (Session tempSession = sessionImplementor == null ? sessionFactoryImplementor.openTemporarySession() : sessionImplementor.getFactory().openTemporarySession();){
            Object object = tempSession.get(proxy.getHibernateLazyInitializer().getEntityName(), proxy.getHibernateLazyInitializer().getIdentifier());
            return object;
        }
    }

    private static boolean activeProxySession(HibernateProxy proxy) {
        Session session = (Session)proxy.getHibernateLazyInitializer().getSession();
        return session != null && session.isOpen() && session.isConnected();
    }

    public static <T> Class<T> getTargetClassIfProxied(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        if (HibernateProxy.class.isAssignableFrom(clazz)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    public static Class getEntityClass(SessionImplementor sessionImplementor, String entityName) {
        EntityPersister entityPersister = sessionImplementor.getFactory().getMetamodel().entityPersister(entityName);
        return entityPersister.getMappedClass();
    }
}

