/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public class TypedEnumMarshaller<E extends Enum<E>>
implements ProtoStreamMarshaller<E> {
    private final ProtoStreamMarshaller<Class<?>> typeMarshaller;

    public TypedEnumMarshaller(ProtoStreamMarshaller<Class<?>> typeMarshaller) {
        this.typeMarshaller = typeMarshaller;
    }

    public E readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
        int code = reader.readUInt32();
        Class enumClass = (Class)this.typeMarshaller.readFrom(context, reader);
        EnumMarshaller marshaller = (EnumMarshaller)context.getMarshaller(enumClass);
        return (E)marshaller.decode(code);
    }

    public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, E value) throws IOException {
        Class enumClass = ((Enum)value).getDeclaringClass();
        EnumMarshaller marshaller = (EnumMarshaller)context.getMarshaller(enumClass);
        int code = marshaller.encode(value);
        writer.writeUInt32NoTag(code);
        this.typeMarshaller.writeTo(context, writer, enumClass);
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, E value) {
        OptionalInt typeSize = this.typeMarshaller.size(context, ((Enum)value).getDeclaringClass());
        return typeSize.isPresent() ? OptionalInt.of(typeSize.getAsInt() + Predictable.unsignedIntSize(((Enum)value).ordinal())) : typeSize;
    }

    public Class<? extends E> getJavaClass() {
        return null;
    }
}

