/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.store.spi.DirectoryHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FSDirectoryProvider
implements DirectoryProvider<FSDirectory> {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private FSDirectory directory;

    @Override
    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        boolean manual = IndexingMode.MANUAL == context.getIndexingMode();
        Path indexDir = DirectoryHelper.getVerifiedIndexPath(directoryProviderName, properties, !manual);
        try {
            this.directory = DirectoryProviderHelper.createFSIndex(indexDir, properties, context.getServiceManager());
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + directoryProviderName, e);
        }
    }

    @Override
    public void start(DirectoryBasedIndexManager indexManager) {
    }

    @Override
    public void stop() {
        try {
            this.directory.close();
        }
        catch (Exception e) {
            log.unableToCloseLuceneDirectory(this.directory.getDirectory(), e);
        }
    }

    @Override
    public FSDirectory getDirectory() {
        return this.directory;
    }

    public boolean equals(Object obj) {
        throw new AssertionFailure("this type can not be compared reliably");
    }

    public int hashCode() {
        throw new AssertionFailure("this type can not be compared reliably");
    }
}

