/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;

public class ProviderExtensionSupport {
    private static Logger log = Logger.getLogger(ProviderExtensionSupport.class);
    private Set<Type> providerOptionalTypes = new HashSet<Type>();
    private Set<Annotation> providerQualifiers = new HashSet<Annotation>();

    public void addTypeToClaimProducer(@Observes ProcessBeanAttributes pba) {
        Claim claim;
        if (!this.providerOptionalTypes.isEmpty() && pba.getAnnotated().isAnnotationPresent(Claim.class) && (claim = (Claim)pba.getAnnotated().getAnnotation(Claim.class)).value().length() == 0 && claim.standard() == Claims.UNKNOWN) {
            log.debugf("addTypeToClaimProducer: %s\n", (Object)pba.getAnnotated());
            BeanAttributes delegate = pba.getBeanAttributes();
            if (delegate.getTypes().contains(Optional.class)) {
                pba.setBeanAttributes((BeanAttributes)new ProviderBeanAttributes((BeanAttributes<Object>)delegate, this.providerOptionalTypes, this.providerQualifiers));
            }
        }
    }

    void processClaimProviderInjections(@Observes ProcessInjectionPoint<?, ? extends Provider> pip) {
        log.debugf("pip: %s", (Object)pip.getInjectionPoint());
        InjectionPoint ip = pip.getInjectionPoint();
        if (ip.getAnnotated().isAnnotationPresent(Claim.class)) {
            Type innerType;
            Claim claim = (Claim)ip.getAnnotated().getAnnotation(Claim.class);
            if (claim.value().length() == 0 && claim.standard() == Claims.UNKNOWN) {
                pip.addDefinitionError((Throwable)new DeploymentException("@Claim at: " + ip + " has no name or valid standard enum setting"));
            }
            boolean usesEnum = claim.standard() != Claims.UNKNOWN;
            String claimName = usesEnum ? claim.standard().name() : claim.value();
            log.debugf("Checking Provider Claim(%s), ip: %s", (Object)claimName, (Object)ip);
            Type matchType = ip.getType();
            Type actualType = ((ParameterizedType)matchType).getActualTypeArguments()[0];
            if (ProviderExtensionSupport.isOptional(actualType) && !ProviderExtensionSupport.isJson(innerType = ((ParameterizedType)actualType).getActualTypeArguments()[0])) {
                this.providerOptionalTypes.add(actualType);
                this.providerQualifiers.add((Annotation)claim);
            }
        }
    }

    private static boolean isOptional(Type type) {
        return type.getTypeName().startsWith(Optional.class.getTypeName());
    }

    private static boolean isJson(Type type) {
        return type.getTypeName().startsWith("jakarta.json.Json");
    }

    public static class ProviderBeanAttributes
    implements BeanAttributes<Object> {
        private BeanAttributes<Object> delegate;
        private Set<Type> types;
        private Set<Annotation> qualifiers;

        public ProviderBeanAttributes(BeanAttributes<Object> delegate, Set<Type> types, Set<Annotation> qualifiers) {
            this.delegate = delegate;
            this.types = types;
            this.qualifiers = qualifiers;
        }

        public Set<Type> getTypes() {
            return this.types;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return this.delegate.getScope();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return this.delegate.getStereotypes();
        }

        public boolean isAlternative() {
            return this.delegate.isAlternative();
        }
    }
}

