/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.build.JwtException;
import io.smallrye.jwt.build.JwtSignatureException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.jwt.Claims;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;

public class JwtSigningUtils {
    private JwtSigningUtils() {
    }

    public static String signWithPemKey(String pemKeyLocation, String jwtLocation) {
        return JwtSigningUtils.signWithPemKey(pemKeyLocation, (String)null, jwtLocation);
    }

    public static String signWithPemKey(String pemKeyLocation, String keyId, String jwtLocation) {
        return JwtSigningUtils.signWithPemKey(pemKeyLocation, JwtSigningUtils.kidToMap(keyId), jwtLocation);
    }

    public static String signWithPemKey(String pemKeyLocation, Map<String, Object> headers, String jwtLocation) {
        return JwtSigningUtils.readClaimsAndSign(JwtSigningUtils.readPrivatePemKey(pemKeyLocation), headers, jwtLocation);
    }

    public static String signWithPemKey(String pemKeyLocation, Map<String, Object> claims) {
        return JwtSigningUtils.signWithPemKey(pemKeyLocation, (String)null, claims);
    }

    public static String signWithPemKey(String pemKeyLocation, String keyId, Map<String, Object> claims) {
        return JwtSigningUtils.signWithPemKey(pemKeyLocation, JwtSigningUtils.kidToMap(keyId), claims);
    }

    public static String signWithPemKey(String pemKeyLocation, Map<String, Object> headers, Map<String, Object> claims) {
        return JwtSigningUtils.convertToClaimsAndSign(JwtSigningUtils.readPrivatePemKey(pemKeyLocation), headers, claims);
    }

    public static String signWithJwk(String jwkLocation, String jwtLocation) {
        return JwtSigningUtils.signWithJwk(jwkLocation, Collections.emptyMap(), jwtLocation);
    }

    public static String signWithJwk(String jwkLocation, Map<String, Object> headers, String jwtLocation) {
        return JwtSigningUtils.readClaimsAndSignWithJwk(JwtSigningUtils.createJsonWebKey(JwtSigningUtils.readJsonContent(jwkLocation)), headers, jwtLocation);
    }

    public static String signWithJwk(String jwkLocation, Map<String, Object> claims) {
        return JwtSigningUtils.signWithJwk(jwkLocation, Collections.emptyMap(), claims);
    }

    public static String signWithJwk(String jwkLocation, Map<String, Object> headers, Map<String, Object> claims) {
        return JwtSigningUtils.convertToClaimsAndSignWithJwk(JwtSigningUtils.createJsonWebKey(JwtSigningUtils.readJsonContent(jwkLocation)), headers, claims);
    }

    public static String signWithJwkFromSet(String jwkSetLocation, String keyId, String jwtLocation) {
        return JwtSigningUtils.signWithJwkFromSet(jwkSetLocation, JwtSigningUtils.kidToMap(keyId), jwtLocation);
    }

    public static String signWithJwkFromSet(String jwkSetLocation, Map<String, Object> headers, String jwtLocation) {
        JsonWebKey jwk = JwtSigningUtils.findJsonWebKeyInSet(JwtSigningUtils.readJsonContent(jwkSetLocation), (String)headers.get("kid"));
        return JwtSigningUtils.readClaimsAndSignWithJwk(jwk, headers, jwtLocation);
    }

    public static String signWithJwkFromSet(String jwkSetLocation, String keyId, Map<String, Object> claims) {
        return JwtSigningUtils.signWithJwkFromSet(jwkSetLocation, JwtSigningUtils.kidToMap(keyId), claims);
    }

    public static String signWithJwkFromSet(String jwkSetLocation, Map<String, Object> headers, Map<String, Object> claims) {
        JsonWebKey jwk = JwtSigningUtils.findJsonWebKeyInSet(JwtSigningUtils.readJsonContent(jwkSetLocation), (String)headers.get("kid"));
        return JwtSigningUtils.convertToClaimsAndSignWithJwk(jwk, headers, claims);
    }

    public static String signWithPrivateKey(PrivateKey privateKey, String jwtLocation) {
        return JwtSigningUtils.signWithPrivateKey(privateKey, (String)null, jwtLocation);
    }

    public static String signWithPrivateKey(PrivateKey privateKey, String keyId, String jwtLocation) {
        return JwtSigningUtils.signWithPrivateKey(privateKey, JwtSigningUtils.kidToMap(keyId), jwtLocation);
    }

    public static String signWithPrivateKey(PrivateKey privateKey, Map<String, Object> headers, String jwtLocation) {
        return JwtSigningUtils.readClaimsAndSign(privateKey, headers, jwtLocation);
    }

    public static String signWithPrivateKey(PrivateKey privateKey, Map<String, Object> claims) {
        return JwtSigningUtils.signWithPrivateKey(privateKey, (String)null, claims);
    }

    public static String signWithPrivateKey(PrivateKey privateKey, String keyId, Map<String, Object> claims) {
        return JwtSigningUtils.signWithPrivateKey(privateKey, JwtSigningUtils.kidToMap(keyId), claims);
    }

    public static String signWithPrivateKey(PrivateKey privateKey, Map<String, Object> headers, Map<String, Object> claims) {
        return JwtSigningUtils.convertToClaimsAndSign(privateKey, headers, claims);
    }

    public static String signWithSecretKey(SecretKey secretKey, Map<String, Object> claims) {
        return JwtSigningUtils.signWithSecretKey(secretKey, (String)null, claims);
    }

    public static String signWithSecretKey(SecretKey secretKey, String keyId, Map<String, Object> claims) {
        return JwtSigningUtils.signWithSecretKey(secretKey, JwtSigningUtils.kidToMap(keyId), claims);
    }

    public static String signWithSecretKey(SecretKey secretKey, Map<String, Object> headers, Map<String, Object> claims) {
        return JwtSigningUtils.convertToClaimsAndSign(secretKey, headers, claims);
    }

    public static String signWithSecretKey(SecretKey secretKey, String jwtLocation) {
        return JwtSigningUtils.signWithSecretKey(secretKey, (String)null, jwtLocation);
    }

    public static String signWithSecretKey(SecretKey secretKey, String keyId, String jwtLocation) {
        return JwtSigningUtils.signWithSecretKey(secretKey, JwtSigningUtils.kidToMap(keyId), jwtLocation);
    }

    public static String signWithSecretKey(SecretKey secretKey, Map<String, Object> headers, String jwtLocation) {
        return JwtSigningUtils.readClaimsAndSign(secretKey, headers, jwtLocation);
    }

    public static String sign(Map<String, Object> claims) {
        return JwtSigningUtils.sign((String)null, claims);
    }

    public static String sign(String keyId, Map<String, Object> claims) {
        return JwtSigningUtils.sign(JwtSigningUtils.kidToMap(keyId), claims);
    }

    public static String sign(Map<String, Object> headers, Map<String, Object> claims) {
        return JwtSigningUtils.convertToClaimsAndSign(JwtSigningUtils.getSigningKeyFromConfig((String)headers.get("kid")), headers, claims);
    }

    static String readClaimsAndSign(Key signingKey, Map<String, Object> headers, String jwtLocation) {
        return JwtSigningUtils.signJwtClaimsInternal(signingKey, headers, JwtSigningUtils.parseJwtClaims(jwtLocation));
    }

    static String convertToClaimsAndSign(Key signingKey, Map<String, Object> headers, Map<String, Object> claimsMap) {
        return JwtSigningUtils.signJwtClaimsInternal(signingKey, headers, JwtSigningUtils.convertToClaims(claimsMap));
    }

    static String signJwtClaimsInternal(Map<String, Object> headers, JwtClaims claims) {
        Key key = "none".equals(headers.get("alg")) ? null : JwtSigningUtils.getSigningKeyFromConfig((String)headers.get("kid"));
        return JwtSigningUtils.signJwtClaimsInternal(key, headers, claims);
    }

    static String signJwtClaimsInternal(Key signingKey, Map<String, Object> headers, JwtClaims claims) {
        String algorithm;
        JwtSigningUtils.setDefaultJwtClaims(claims);
        JsonWebSignature jws = new JsonWebSignature();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            jws.setHeader(entry.getKey(), entry.getValue());
        }
        if (!headers.containsKey("typ")) {
            jws.setHeader("typ", "JWT");
        }
        if ((algorithm = (String)headers.get("alg")) == null) {
            algorithm = JwtSigningUtils.keyAlgorithm(headers, signingKey);
            jws.setAlgorithmHeaderValue(algorithm);
        }
        if ("none".equals(algorithm)) {
            jws.setAlgorithmConstraints(AlgorithmConstraints.ALLOW_ONLY_NONE);
        }
        jws.setPayload(claims.toJson());
        if (signingKey instanceof RSAPrivateKey && algorithm.startsWith("RS") && ((RSAPrivateKey)signingKey).getModulus().bitLength() < 2048) {
            throw new JwtSignatureException("A key of size 2048 bits or larger MUST be used with the '" + algorithm + "' algorithm");
        }
        jws.setKey(signingKey);
        try {
            return jws.getCompactSerialization();
        }
        catch (Exception ex) {
            throw new JwtSignatureException("Failure to create a signed JWT token: " + ex, ex);
        }
    }

    static void setDefaultJwtClaims(JwtClaims claims) {
        long currentTimeInSecs = JwtSigningUtils.currentTimeInSecs();
        if (!claims.hasClaim(Claims.iat.name())) {
            claims.setIssuedAt(NumericDate.fromSeconds((long)currentTimeInSecs));
        }
        if (!claims.hasClaim(Claims.exp.name())) {
            claims.setExpirationTime(NumericDate.fromSeconds((long)(JwtSigningUtils.currentTimeInSecs() + 300)));
        }
        if (!claims.hasClaim(Claims.jti.name())) {
            claims.setGeneratedJwtId();
        }
    }

    static String readClaimsAndSignWithJwk(JsonWebKey jwk, Map<String, Object> headers, String jwtLocation) {
        return JwtSigningUtils.signJwtClaimsWithJwkInternal(jwk, headers, JwtSigningUtils.parseJwtClaims(jwtLocation));
    }

    static String convertToClaimsAndSignWithJwk(JsonWebKey jwk, Map<String, Object> headers, Map<String, Object> claims) {
        return JwtSigningUtils.signJwtClaimsWithJwkInternal(jwk, headers, JwtSigningUtils.convertToClaims(claims));
    }

    static String signJwtClaimsWithJwkInternal(JsonWebKey jwk, Map<String, Object> headers, JwtClaims claims) {
        Key key = jwk.getKey();
        if (key instanceof PrivateKey || key instanceof SecretKey) {
            HashMap<String, Object> newHeaders = new HashMap<String, Object>();
            newHeaders.putAll(headers);
            if (!newHeaders.containsKey("kid") && jwk.getKeyId() != null) {
                newHeaders.put("kid", jwk.getKeyId());
            }
            if (!newHeaders.containsKey("alg") && jwk.getAlgorithm() != null) {
                newHeaders.put("alg", jwk.getAlgorithm());
            }
            String alg = (String)newHeaders.get("alg");
            if (key instanceof SecretKey && !alg.startsWith("HS") || key instanceof RSAPrivateKey && !alg.startsWith("RS") || key instanceof ECPrivateKey && !alg.startsWith("ES")) {
                throw new IllegalArgumentException("JWK algorithm 'alg' value does not match a key type");
            }
            return JwtSigningUtils.signJwtClaimsInternal(key, newHeaders, claims);
        }
        throw new IllegalArgumentException("Only PrivateKey or SecretKey can be be used to sign a token");
    }

    static String keyAlgorithm(Map<String, Object> headers, Key signingKey) {
        String alg = (String)headers.get("alg");
        if (signingKey instanceof RSAPrivateKey) {
            if (alg == null) {
                return SignatureAlgorithm.RS256.name();
            }
            if (alg.startsWith("RS")) {
                return alg;
            }
        } else if (signingKey instanceof ECPrivateKey) {
            if (alg == null) {
                return SignatureAlgorithm.ES256.name();
            }
            if (alg.startsWith("ES")) {
                return alg;
            }
        } else if (signingKey instanceof SecretKey) {
            if (alg == null) {
                return SignatureAlgorithm.HS256.name();
            }
            if (alg.startsWith("HS")) {
                return alg;
            }
        }
        throw new IllegalArgumentException("Unsupported signature algorithm: " + signingKey.getAlgorithm());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readJsonContent(String jsonResName) {
        try {
            InputStream contentIS = JwtSigningUtils.class.getResourceAsStream(jsonResName);
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(contentIS));){
                String string = buffer.lines().collect(Collectors.joining("\n"));
                return string;
            }
        }
        catch (IOException ex) {
            throw new JwtException("Failure to read the json content:" + ex, ex);
        }
    }

    static JwtClaims convertToClaims(Map<String, Object> claimsMap) {
        JwtClaims claims = new JwtClaims();
        JwtSigningUtils.convertToClaims(claims, claimsMap);
        return claims;
    }

    static void convertToClaims(JwtClaims claims, Map<String, Object> claimsMap) {
        for (Map.Entry<String, Object> entry : claimsMap.entrySet()) {
            claims.setClaim(entry.getKey(), entry.getValue());
        }
    }

    static int currentTimeInSecs() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    static JsonWebKey createJsonWebKey(String jwkString) {
        try {
            return JsonWebKey.Factory.newJwk((Map)JsonUtil.parseJson((String)jwkString));
        }
        catch (Exception ex) {
            throw new JwtException("Failure to parse JWK:" + ex, ex);
        }
    }

    static JsonWebKey findJsonWebKeyInSet(String jwkSetString, String keyId) {
        JsonWebKeySet jwkSet = null;
        try {
            jwkSet = new JsonWebKeySet(jwkSetString);
        }
        catch (Exception ex) {
            throw new JwtException("Failure to parse JWK Set:" + ex, ex);
        }
        if (keyId == null) {
            if (jwkSet.getJsonWebKeys().size() == 1) {
                return (JsonWebKey)jwkSet.getJsonWebKeys().get(0);
            }
            throw new IllegalArgumentException("Key id 'kid' header value must be provided");
        }
        JsonWebKey jwk = jwkSet.findJsonWebKey(keyId, null, null, null);
        if (jwk == null) {
            throw new IllegalArgumentException("JWK set has no key with a key id 'kid' header '" + keyId + "'");
        }
        return jwk;
    }

    static Map<String, Object> kidToMap(String keyId) {
        return keyId == null ? Collections.emptyMap() : Collections.singletonMap("kid", keyId);
    }

    static Key getSigningKeyFromConfig(String kid) {
        try {
            String keyLocation = (String)ConfigProvider.getConfig().getValue("smallrye.jwt.sign.key-location", String.class);
            try {
                return KeyUtils.readSigningKey(keyLocation, kid);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Signing key can not be loaded from: " + keyLocation);
            }
        }
        catch (NoSuchElementException ex) {
            throw new IllegalArgumentException("Please set a 'smallrye.jwt.sign.key-location' property");
        }
    }

    static JwtClaims parseJwtClaims(String jwtLocation) {
        try {
            return JwtClaims.parse((String)JwtSigningUtils.readJsonContent(jwtLocation));
        }
        catch (Exception ex) {
            throw new JwtException("Failure to parse the JWT claims:" + ex, ex);
        }
    }

    static Key readPrivatePemKey(String pemKeyLocation) {
        try {
            return KeyUtils.readPrivateKey(pemKeyLocation);
        }
        catch (Exception ex) {
            throw new JwtException("Failure to read the private key:" + ex, ex);
        }
    }
}

