/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import jakarta.mail.Session;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.mail.extension.MailLogger;
import org.jboss.as.mail.extension.MailSessionConfig;
import org.jboss.as.mail.extension.SessionProvider;
import org.jboss.as.mail.extension.SessionProviderFactory;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.MapInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class MailSessionService
implements Service<Session> {
    private final MailSessionConfig config;
    private volatile SessionProvider provider;
    private Map<String, OutboundSocketBinding> socketBindings = new HashMap<String, OutboundSocketBinding>();

    public MailSessionService(MailSessionConfig config) {
        MailLogger.ROOT_LOGGER.tracef("service constructed with config: %s", config);
        this.config = config;
    }

    public MailSessionConfig getConfig() {
        return this.config;
    }

    public void start(StartContext startContext) throws StartException {
        MailLogger.ROOT_LOGGER.trace("start...");
        this.provider = SessionProviderFactory.create(this.config, this.socketBindings);
    }

    public void stop(StopContext stopContext) {
        MailLogger.ROOT_LOGGER.trace("stop...");
    }

    Injector<OutboundSocketBinding> getSocketBindingInjector(String name) {
        return new MapInjector(this.socketBindings, (Object)name);
    }

    public Session getValue() throws IllegalStateException, IllegalArgumentException {
        return this.provider.getSession();
    }
}

