/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v53.access;

import jakarta.transaction.Synchronization;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;

public final class SessionAccessImpl
implements SessionAccess {
    public SessionAccess.TransactionCoordinatorAccess getTransactionCoordinator(Object session) {
        return session == null ? null : new TransactionCoordinatorAccessImpl(SessionAccessImpl.unwrap(session).getTransactionCoordinator());
    }

    public long getTimestamp(Object session) {
        return SessionAccessImpl.unwrap(session).getTransactionStartTimestamp();
    }

    private static SharedSessionContractImplementor unwrap(Object session) {
        return (SharedSessionContractImplementor)session;
    }

    private static final class TransactionCoordinatorAccessImpl
    implements SessionAccess.TransactionCoordinatorAccess {
        private final TransactionCoordinator txCoordinator;

        public TransactionCoordinatorAccessImpl(TransactionCoordinator txCoordinator) {
            this.txCoordinator = txCoordinator;
        }

        public void registerLocalSynchronization(Synchronization sync) {
            this.txCoordinator.getLocalSynchronizations().registerSynchronization(sync);
        }

        public IsolationDelegate createIsolationDelegate() {
            return this.txCoordinator.createIsolationDelegate();
        }

        public boolean isJoined() {
            return this.txCoordinator.isJoined();
        }
    }
}

