/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.jboss;

import jakarta.transaction.SystemException;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.XAResourceRegistry;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;

final class FileSystemXAResourceRegistry {
    private static final String RECOVERY_DIR = "ejb-xa-recovery";
    private static final XAResource[] EMPTY_IN_DOUBT_RESOURCES = new XAResource[0];
    private static final Object XA_RESOURCE_REGISTRY_KEY = new Object();
    private final LocalTransactionProvider provider;
    private final Path xaRecoveryPath;
    private final FilePermission xaRecoveryDirPermission;
    private final Set<String> openFilePaths = Collections.synchronizedSet(new HashSet());
    private final Set<XAResource> inDoubtResources = Collections.synchronizedSet(new HashSet());

    FileSystemXAResourceRegistry(LocalTransactionProvider provider, Path relativePath) {
        this.provider = provider;
        this.xaRecoveryPath = relativePath == null ? FileSystems.getDefault().getPath(RECOVERY_DIR, new String[0]) : relativePath.resolve(RECOVERY_DIR);
        this.xaRecoveryDirPermission = new FilePermission(this.xaRecoveryPath.toString() + File.separatorChar + '*', "read,write");
    }

    XAResourceRegistry getXAResourceRegistryFile(LocalTransaction transaction) throws SystemException {
        XAResourceRegistry registry = (XAResourceRegistry)transaction.getResource(XA_RESOURCE_REGISTRY_KEY);
        if (registry != null) {
            return registry;
        }
        registry = new XAResourceRegistryFile(transaction.getXid());
        transaction.putResource(XA_RESOURCE_REGISTRY_KEY, registry);
        return registry;
    }

    XAResource[] getInDoubtXAResources() {
        try {
            this.recoverInDoubtRegistries();
        }
        catch (IOException e) {
            throw Log.log.unexpectedExceptionOnXAResourceRecovery(e);
        }
        return this.inDoubtResources.isEmpty() ? EMPTY_IN_DOUBT_RESOURCES : this.inDoubtResources.toArray(new XAResource[0]);
    }

    private void recoverInDoubtRegistries() throws IOException {
        File recoveryDir = this.xaRecoveryPath.toFile();
        if (!recoveryDir.exists()) {
            return;
        }
        String[] xaRecoveryFileNames = recoveryDir.list();
        if (xaRecoveryFileNames == null) {
            Log.log.listXAResourceRecoveryFilesNull(recoveryDir);
            return;
        }
        for (String xaRecoveryFileName : xaRecoveryFileNames) {
            if (this.openFilePaths.contains(xaRecoveryFileName)) continue;
            new XAResourceRegistryFile(xaRecoveryFileName, this.provider);
        }
    }

    private final class XAResourceRegistryFile
    extends XAResourceRegistry {
        @NotNull
        private final Path filePath;
        private final FileChannel fileChannel;
        private final Set<XAResource> resources = Collections.synchronizedSet(new HashSet());

        XAResourceRegistryFile(Xid xid) throws SystemException {
            String xidString = SimpleXid.of(xid).toHexString('_');
            this.filePath = FileSystemXAResourceRegistry.this.xaRecoveryPath.resolve(xidString);
            try {
                SecurityManager sm = System.getSecurityManager();
                this.fileChannel = sm == null ? this.openRecoveryFile() : AccessController.doPrivileged(() -> {
                    sm.checkPermission(FileSystemXAResourceRegistry.this.xaRecoveryDirPermission);
                    return this.openRecoveryFile();
                });
                FileSystemXAResourceRegistry.this.openFilePaths.add(xidString);
                this.fileChannel.lock();
                Log.log.xaResourceRecoveryFileCreated(this.filePath);
            }
            catch (PrivilegedActionException e) {
                throw Log.log.createXAResourceRecoveryFileFailed(this.filePath, (IOException)e.getCause());
            }
            catch (IOException e) {
                throw Log.log.createXAResourceRecoveryFileFailed(this.filePath, e);
            }
        }

        private XAResourceRegistryFile(String inDoubtFileName, LocalTransactionProvider provider) throws IOException {
            this.filePath = FileSystemXAResourceRegistry.this.xaRecoveryPath.resolve(inDoubtFileName);
            this.fileChannel = null;
            FileSystemXAResourceRegistry.this.openFilePaths.add(inDoubtFileName);
            this.loadInDoubtResources(provider.getNodeName());
            Log.log.xaResourceRecoveryRegistryReloaded(this.filePath);
        }

        @Override
        protected void addResource(XAResource resource, Xid xid, URI uri) throws SystemException {
            assert (this.fileChannel != null);
            if (!this.resources.add(resource)) {
                return;
            }
            try {
                assert (this.fileChannel.isOpen());
                String record = uri.toString() + System.lineSeparator() + SimpleXid.of(xid).toHexString() + System.lineSeparator();
                this.fileChannel.write(ByteBuffer.wrap(record.getBytes(StandardCharsets.UTF_8)));
                this.fileChannel.force(true);
            }
            catch (IOException e) {
                throw Log.log.appendXAResourceRecoveryFileFailed(uri, this.filePath, e);
            }
            Log.log.xaResourceAddedToRecoveryRegistry(uri, this.filePath);
        }

        @Override
        protected void removeResource(XAResource resource) throws XAException {
            if (this.resources.remove(resource)) {
                if (this.resources.isEmpty()) {
                    try {
                        if (this.fileChannel != null) {
                            this.fileChannel.close();
                        }
                        Files.delete(this.filePath);
                        FileSystemXAResourceRegistry.this.openFilePaths.remove(this.filePath.getFileName().toString());
                    }
                    catch (IOException e) {
                        throw Log.log.deleteXAResourceRecoveryFileFailed(-3, this.filePath, resource, e);
                    }
                    Log.log.xaResourceRecoveryFileDeleted(this.filePath);
                }
                FileSystemXAResourceRegistry.this.inDoubtResources.remove(resource);
            }
        }

        @Override
        protected void resourceInDoubt(XAResource resource) {
            FileSystemXAResourceRegistry.this.inDoubtResources.add(resource);
        }

        private FileChannel openRecoveryFile() throws IOException {
            FileSystemXAResourceRegistry.this.xaRecoveryPath.toFile().mkdir();
            return FileChannel.open(this.filePath, StandardOpenOption.APPEND, StandardOpenOption.CREATE_NEW);
        }

        private void loadInDoubtResources(String nodeName) throws IOException {
            String line;
            List<String> lines;
            assert (this.fileChannel == null);
            try {
                lines = Files.readAllLines(this.filePath);
            }
            catch (IOException e) {
                throw Log.log.readXAResourceRecoveryFileFailed(this.filePath, e);
            }
            Iterator<String> linesIterator = lines.iterator();
            while (linesIterator.hasNext() && (!(line = linesIterator.next()).isEmpty() || linesIterator.hasNext())) {
                URI uri;
                try {
                    uri = new URI(line);
                }
                catch (URISyntaxException e) {
                    throw Log.log.readURIFromXAResourceRecoveryFileFailed(line, this.filePath, e);
                }
                SimpleXid xid = null;
                if (linesIterator.hasNext()) {
                    line = linesIterator.next();
                    if (line.isEmpty() && linesIterator.hasNext()) {
                        line = linesIterator.next();
                    }
                    try {
                        xid = SimpleXid.of(line);
                    }
                    catch (Exception e) {
                        throw Log.log.readXidFromXAResourceRecoveryFileFailed(line, this.filePath, e);
                    }
                }
                XAResource xaresource = this.reloadInDoubtResource(uri, nodeName, xid);
                this.resources.add(xaresource);
                FileSystemXAResourceRegistry.this.inDoubtResources.add(xaresource);
                Log.log.xaResourceRecoveredFromRecoveryRegistry(uri, this.filePath);
            }
        }
    }
}

