/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.resources;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.jboss.security.authorization.ResourceType;
import org.jboss.security.authorization.resources.JavaEEResource;
import org.jboss.security.authorization.resources.SecurityActions;

public class WebResource
extends JavaEEResource {
    public static final String WEB_AUDIT_FLAG = "org.jboss.security.web.audit";
    private ServletRequest servletRequest = null;
    private ServletResponse servletResponse = null;
    private String servletName = null;
    private String canonicalRequestURI = null;
    private static String auditFlag = " ";

    public WebResource() {
    }

    public WebResource(Map<String, Object> map) {
        this.map = map;
    }

    @Override
    public ResourceType getLayer() {
        return ResourceType.WEB;
    }

    public String getCanonicalRequestURI() {
        return this.canonicalRequestURI;
    }

    public void setCanonicalRequestURI(String canonicalRequestURI) {
        this.canonicalRequestURI = canonicalRequestURI;
    }

    public ServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public void setServletRequest(ServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public ServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public void setServletResponse(ServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[").append(this.getClass().getName()).append(":contextMap=").append(this.map).append(",canonicalRequestURI=").append(this.canonicalRequestURI);
        if (!auditFlag.contains("off")) {
            buf.append(",request=").append(this.deriveUsefulInfo()).append(",CodeSource=").append(this.codeSource).append("]");
        }
        return buf.toString();
    }

    private String deriveUsefulInfo() {
        if (!(this.servletRequest instanceof HttpServletRequest)) {
            return " ";
        }
        HttpServletRequest httpRequest = (HttpServletRequest)this.servletRequest;
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(httpRequest.getContextPath());
        if (auditFlag.contains("cookies")) {
            sb.append(":cookies=").append(Arrays.toString(httpRequest.getCookies()));
        }
        if (auditFlag.contains("headers")) {
            sb.append(":headers=");
            Enumeration en = httpRequest.getHeaderNames();
            while (en.hasMoreElements()) {
                String headerName = (String)en.nextElement();
                sb.append(headerName).append("=");
                if (headerName.contains("authorization")) continue;
                sb.append(httpRequest.getHeader(headerName)).append(",");
            }
            sb.append("]");
        }
        if (auditFlag.contains("parameters")) {
            sb.append("[parameters=");
            Enumeration enparam = httpRequest.getParameterNames();
            while (enparam.hasMoreElements()) {
                String paramName = (String)enparam.nextElement();
                sb.append(paramName).append("=");
                if (paramName.equalsIgnoreCase("j_password")) {
                    sb.append("***");
                } else {
                    String[] paramValues = httpRequest.getParameterValues(paramName);
                    int len = paramValues != null ? paramValues.length : 0;
                    for (int i = 0; i < len; ++i) {
                        sb.append(paramValues[i]).append("::");
                    }
                }
                sb.append(",");
            }
        }
        if (auditFlag.contains("attributes")) {
            sb.append("][attributes=");
            Enumeration enu = httpRequest.getAttributeNames();
            while (enu.hasMoreElements()) {
                String attrName = (String)enu.nextElement();
                sb.append(attrName).append("=");
                sb.append(httpRequest.getAttribute(attrName)).append(",");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        auditFlag = SecurityActions.getSystemProperty(WEB_AUDIT_FLAG, " ").toLowerCase(Locale.ENGLISH);
    }
}

