/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration;

import java.util.Collection;
import java.util.Collections;
import org.infinispan.commons.configuration.BaseConfigurationInfo;
import org.infinispan.commons.configuration.elements.ElementDefinition;

public interface ConfigurationBuilderInfo
extends BaseConfigurationInfo {
    default public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return Collections.emptyList();
    }

    default public ConfigurationBuilderInfo getBuilderInfo(String name, String qualifier) {
        if (this.getElementDefinition().supports(name)) {
            return this;
        }
        for (ConfigurationBuilderInfo childElement : this.getChildrenInfo()) {
            ConfigurationBuilderInfo mergedChildren;
            ElementDefinition element = childElement.getElementDefinition();
            if (element != null && element.supports(name)) {
                return childElement;
            }
            boolean isTopLevel = element != null && element.isTopLevel();
            if (isTopLevel || (mergedChildren = childElement.getBuilderInfo(name, qualifier)) == null) continue;
            return mergedChildren;
        }
        return null;
    }

    default public ConfigurationBuilderInfo getNewBuilderInfo(String name) {
        return null;
    }
}

