/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs;

import io.undertow.servlet.handlers.ServletHandler;
import jakarta.servlet.Servlet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jaxrs.JaxrsExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.wildfly.extension.undertow.DeploymentDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentService;

public class JaxrsDeploymentDefinition
extends SimpleResourceDefinition {
    public static final JaxrsDeploymentDefinition INSTANCE = new JaxrsDeploymentDefinition();
    public static final String SHOW_RESOURCES = "show-resources";
    public static final AttributeDefinition CLASSNAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("resource-class", ModelType.STRING, true).setStorageRuntime()).build();
    public static final AttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("resource-path", ModelType.STRING, true).setStorageRuntime()).build();
    public static final AttributeDefinition METHOD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("jaxrs-resource-method", ModelType.STRING, false).setStorageRuntime()).build();
    public static final AttributeDefinition METHODS = ((SimpleListAttributeDefinition.Builder)new SimpleListAttributeDefinition.Builder("resource-methods", METHOD).setStorageRuntime()).build();
    public static final ObjectTypeAttributeDefinition JAXRS_RESOURCE = ((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("jaxrs-resource", new AttributeDefinition[]{CLASSNAME, PATH, METHODS}).setStorageRuntime()).build();

    private JaxrsDeploymentDefinition() {
        super(new SimpleResourceDefinition.Parameters(JaxrsExtension.SUBSYSTEM_PATH, JaxrsExtension.getResolver(new String[0])).setFeature(false));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)ShowJaxrsResourcesHandler.DEFINITION, (OperationStepHandler)new ShowJaxrsResourcesHandler());
    }

    private static class ShowJaxrsResourcesHandler
    implements OperationStepHandler {
        public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("show-resources", JaxrsExtension.getResolver("deployment")).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setDeprecated(ModelVersion.create((int)2, (int)0, (int)0)).setReplyParameters(new AttributeDefinition[]{JAXRS_RESOURCE}).build();

        private ShowJaxrsResourcesHandler() {
        }

        void handle(ModelNode response, String contextRootPath, Collection<String> servletMappings, String mapping, List<ResourceInvoker> resources) {
            for (ResourceInvoker resourceInvoker : resources) {
                if (!ResourceMethodInvoker.class.isAssignableFrom(resourceInvoker.getClass())) continue;
                ResourceMethodInvoker resource = (ResourceMethodInvoker)resourceInvoker;
                ModelNode node = new ModelNode();
                node.get(CLASSNAME.getName()).set(resource.getResourceClass().getCanonicalName());
                node.get(PATH.getName()).set(mapping);
                for (String servletMapping : servletMappings) {
                    String method = this.formatMethod(resource, servletMapping, mapping, contextRootPath);
                    for (String httpMethod : resource.getHttpMethods()) {
                        node.get(METHODS.getName()).add(String.format(method, httpMethod));
                    }
                }
                response.add(node);
            }
        }

        private String formatMethod(ResourceMethodInvoker resource, String servletMapping, String path, String contextRootPath) {
            StringBuilder builder = new StringBuilder();
            builder.append("%1$s ");
            String servletPath = servletMapping.replaceAll("\\*", "");
            if (servletPath.charAt(0) == '/') {
                servletPath = servletPath.substring(1);
            }
            builder.append(contextRootPath).append('/').append(servletPath).append(path);
            builder.append(" - ").append(resource.getResourceClass().getCanonicalName()).append('.').append(resource.getMethod().getName()).append('(');
            if (resource.getMethod().getParameterTypes().length > 0) {
                builder.append("...");
            }
            builder.append(')');
            return builder.toString().replaceAll("//", "/");
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            ModelNode subModel = context.readResourceFromRoot(address.subAddress(0, address.size() - 1).append("subsystem", "undertow"), false).getModel();
            String host = DeploymentDefinition.VIRTUAL_HOST.resolveModelAttribute(context, subModel).asString();
            String contextPath = DeploymentDefinition.CONTEXT_ROOT.resolveModelAttribute(context, subModel).asString();
            String server = DeploymentDefinition.SERVER.resolveModelAttribute(context, subModel).asString();
            ServiceController controller = context.getServiceRegistry(false).getService(UndertowService.deploymentServiceName((String)server, (String)host, (String)contextPath));
            UndertowDeploymentService deploymentService = (UndertowDeploymentService)controller.getService();
            try {
                deploymentService.getDeployment().createThreadSetupAction((exchange, ctxObject) -> {
                    Servlet resteasyServlet = null;
                    for (Map.Entry servletHandler : deploymentService.getDeployment().getServlets().getServletHandlers().entrySet()) {
                        if (!HttpServletDispatcher.class.isAssignableFrom(((ServletHandler)servletHandler.getValue()).getManagedServlet().getServletInfo().getServletClass())) continue;
                        resteasyServlet = (Servlet)((ServletHandler)servletHandler.getValue()).getManagedServlet().getServlet().getInstance();
                        break;
                    }
                    if (resteasyServlet != null) {
                        Collection servletMappings = resteasyServlet.getServletConfig().getServletContext().getServletRegistration(resteasyServlet.getServletConfig().getServletName()).getMappings();
                        ResourceMethodRegistry registry = (ResourceMethodRegistry)((HttpServletDispatcher)resteasyServlet).getDispatcher().getRegistry();
                        context.addStep((context1, operation1) -> {
                            if (registry != null) {
                                ModelNode response = new ModelNode();
                                for (Map.Entry resource : registry.getBounded().entrySet()) {
                                    this.handle(response, contextPath, servletMappings, (String)resource.getKey(), (List)resource.getValue());
                                }
                                context1.getResult().set(response);
                            }
                        }, OperationContext.Stage.RUNTIME);
                    }
                    return null;
                }).call(null, null);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

