/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.injection;

import jakarta.faces.FacesException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.naming.NamingException;
import org.apache.myfaces.config.annotation.LifecycleProvider2;
import org.jboss.as.web.common.StartupContext;
import org.jboss.as.web.common.WebInjectionContainer;
import org.wildfly.security.manager.WildFlySecurityManager;

public class MyFacesLifecycleProvider
implements LifecycleProvider2 {
    private final WebInjectionContainer injectionContainer = StartupContext.getInjectionContainer();

    public Object newInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NamingException, InvocationTargetException {
        final Class<?> clazz = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged().loadClass(className);
        if (System.getSecurityManager() == null) {
            return clazz.newInstance();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalAccessException, InstantiationException {
                    return clazz.newInstance();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof IllegalAccessException) {
                throw (IllegalAccessException)e;
            }
            if (e instanceof InstantiationException) {
                throw (InstantiationException)e;
            }
            throw new FacesException((Throwable)e);
        }
    }

    public void postConstruct(Object obj) throws IllegalAccessException, InvocationTargetException {
        try {
            this.injectionContainer.newInstance(obj);
        }
        catch (NamingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public void destroyInstance(Object obj) throws IllegalAccessException, InvocationTargetException {
        this.injectionContainer.destroyInstance(obj);
    }
}

