/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.suspend;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.invocation.InterceptorContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.CreationListener;
import org.wildfly.transaction.client.LocalTransactionContext;

public class EJBSuspendHandlerService
implements Service<EJBSuspendHandlerService>,
ServerActivity,
CreationListener,
Synchronization {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"ejb"}).append(new String[]{"suspend-handler"});
    private static final AtomicIntegerFieldUpdater<EJBSuspendHandlerService> activeInvocationCountUpdater = AtomicIntegerFieldUpdater.newUpdater(EJBSuspendHandlerService.class, "activeInvocationCount");
    private static final AtomicIntegerFieldUpdater<EJBSuspendHandlerService> activeTransactionCountUpdater = AtomicIntegerFieldUpdater.newUpdater(EJBSuspendHandlerService.class, "activeTransactionCount");
    private static final AtomicReferenceFieldUpdater<EJBSuspendHandlerService, ServerActivityCallback> listenerUpdater = AtomicReferenceFieldUpdater.newUpdater(EJBSuspendHandlerService.class, ServerActivityCallback.class, "listener");
    private boolean gracefulTxnShutdown;
    private final InjectedValue<SuspendController> suspendControllerInjectedValue = new InjectedValue();
    private final InjectedValue<LocalTransactionContext> localTransactionContextInjectedValue = new InjectedValue();
    private final InjectedValue<DeploymentRepository> deploymentRepositoryInjectedValue = new InjectedValue();
    private volatile int activeInvocationCount = 0;
    private volatile int activeTransactionCount = 0;
    private volatile boolean suspended = false;
    private volatile ServerActivityCallback listener = null;

    public EJBSuspendHandlerService(boolean gracefulTxnShutdown) {
        this.gracefulTxnShutdown = gracefulTxnShutdown;
    }

    public void enableGracefulTxnShutdown(boolean gracefulTxnShutdown) {
        this.gracefulTxnShutdown = gracefulTxnShutdown;
    }

    public InjectedValue<SuspendController> getSuspendControllerInjectedValue() {
        return this.suspendControllerInjectedValue;
    }

    public InjectedValue<LocalTransactionContext> getLocalTransactionContextInjectedValue() {
        return this.localTransactionContextInjectedValue;
    }

    public InjectedValue<DeploymentRepository> getDeploymentRepositoryInjectedValue() {
        return this.deploymentRepositoryInjectedValue;
    }

    public EJBSuspendHandlerService getValue() {
        return this;
    }

    public void start(StartContext context) {
        SuspendController suspendController = (SuspendController)this.suspendControllerInjectedValue.getValue();
        suspendController.registerActivity((ServerActivity)this);
        LocalTransactionContext localTransactionContext = (LocalTransactionContext)this.localTransactionContextInjectedValue.getValue();
        localTransactionContext.registerCreationListener((CreationListener)this);
    }

    public void stop(StopContext context) {
        SuspendController suspendController = (SuspendController)this.suspendControllerInjectedValue.getValue();
        suspendController.unRegisterActivity((ServerActivity)this);
        LocalTransactionContext localTransactionContext = (LocalTransactionContext)this.localTransactionContextInjectedValue.getValue();
        localTransactionContext.removeCreationListener((CreationListener)this);
    }

    public void preSuspend(ServerActivityCallback listener) {
        listener.done();
    }

    public void suspended(ServerActivityCallback listener) {
        this.suspended = true;
        listenerUpdater.set(this, listener);
        ((LocalTransactionContext)this.localTransactionContextInjectedValue.getValue()).suspendRequests();
        int activeInvocationCount = activeInvocationCountUpdater.get(this);
        if (activeInvocationCount == 0) {
            if (this.gracefulTxnShutdown) {
                if (activeTransactionCountUpdater.get(this) == 0) {
                    this.doneSuspended();
                } else {
                    EjbLogger.ROOT_LOGGER.suspensionWaitingActiveTransactions(activeInvocationCount);
                }
            } else {
                this.doneSuspended();
            }
        }
    }

    public void resume() {
        this.suspended = false;
        ((LocalTransactionContext)this.localTransactionContextInjectedValue.getValue()).resumeRequests();
        ServerActivityCallback listener = listenerUpdater.get(this);
        if (listener != null) {
            listenerUpdater.compareAndSet(this, listener, null);
        }
        ((DeploymentRepository)this.deploymentRepositoryInjectedValue.getValue()).resume();
    }

    public boolean acceptInvocation(InterceptorContext context) throws SystemException {
        if (this.suspended) {
            if (!this.gracefulTxnShutdown) {
                return false;
            }
            if (listenerUpdater.get(this) == null || activeTransactionCountUpdater.get(this) == 0) {
                return false;
            }
            if (!context.hasTransaction()) {
                return false;
            }
        }
        activeInvocationCountUpdater.incrementAndGet(this);
        return true;
    }

    public void invocationComplete() {
        int activeInvocations = activeInvocationCountUpdater.decrementAndGet(this);
        if (this.suspended && activeInvocations == 0 && (!this.gracefulTxnShutdown || activeTransactionCountUpdater.get(this) == 0)) {
            this.doneSuspended();
        }
    }

    public void transactionCreated(AbstractTransaction transaction, CreationListener.CreatedBy createdBy) {
        activeTransactionCountUpdater.incrementAndGet(this);
        try {
            transaction.registerSynchronization((Synchronization)this);
        }
        catch (RollbackException | IllegalStateException e) {
            this.decrementTransactionCount();
        }
        catch (SystemException e) {
            this.decrementTransactionCount();
            EjbLogger.ROOT_LOGGER.debug("Unexpected exception", e);
            throw new RuntimeException(e);
        }
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        this.decrementTransactionCount();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    private void doneSuspended() {
        ServerActivityCallback oldListener = this.listener;
        if (oldListener != null && listenerUpdater.compareAndSet(this, oldListener, null)) {
            ((DeploymentRepository)this.deploymentRepositoryInjectedValue.getValue()).suspend();
            oldListener.done();
            EjbLogger.ROOT_LOGGER.suspensionComplete();
        }
    }

    private void decrementTransactionCount() {
        int activeTransactionCount = activeTransactionCountUpdater.decrementAndGet(this);
        if (this.suspended && activeTransactionCount == 0 && activeInvocationCountUpdater.get(this) == 0) {
            this.doneSuspended();
        }
    }
}

