/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.util.Set;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.ImportedProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.MarshallerByteCodeGenerator;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.osgi.framework.BundleReference;
import protostream.javassist.ClassClassPath;
import protostream.javassist.ClassPool;
import protostream.javassist.LoaderClassPath;
import protostream.javassist.NotFoundException;

public final class RuntimeProtoSchemaGenerator
extends BaseProtoSchemaGenerator {
    private static final boolean IS_OSGI_CONTEXT;
    private final ClassPool classPool;

    public RuntimeProtoSchemaGenerator(XTypeFactory typeFactory, SerializationContext serializationContext, String generator, String fileName, String packageName, Set<XClass> classes, boolean autoImportClasses, ClassLoader classLoader) {
        super(typeFactory, serializationContext, generator, fileName, packageName, classes, autoImportClasses);
        if (classes.isEmpty()) {
            throw new ProtoSchemaBuilderException("At least one class must be specified");
        }
        this.classPool = RuntimeProtoSchemaGenerator.getClassPool(classes, classLoader);
    }

    @Override
    protected ProtoTypeMetadata importProtoTypeMetadata(XClass javaType) {
        BaseMarshaller<?> marshaller;
        try {
            marshaller = this.serializationContext.getMarshaller(javaType.asClass());
        }
        catch (Exception e) {
            return null;
        }
        GenericDescriptor descriptor = this.serializationContext.getDescriptorByName(marshaller.getTypeName());
        return new ImportedProtoTypeMetadata(descriptor, marshaller, javaType);
    }

    @Override
    protected AbstractMarshallerCodeGenerator makeCodeGenerator() {
        try {
            return new MarshallerByteCodeGenerator(this.typeFactory, this.packageName, this.classPool);
        }
        catch (NotFoundException e) {
            throw new ProtoSchemaBuilderException(e);
        }
    }

    private static ClassPool getClassPool(Set<XClass> classes, final ClassLoader classLoader) {
        final ClassLoader myCL = RuntimeProtoSchemaGenerator.class.getClassLoader();
        ClassPool cp = new ClassPool(ClassPool.getDefault()){

            @Override
            public ClassLoader getClassLoader() {
                return classLoader != null ? classLoader : (IS_OSGI_CONTEXT ? myCL : super.getClassLoader());
            }
        };
        for (XClass c : classes) {
            cp.appendClassPath(new ClassClassPath(c.asClass()));
        }
        cp.appendClassPath(new LoaderClassPath(myCL));
        if (classLoader != myCL) {
            cp.appendClassPath(new LoaderClassPath(classLoader));
        }
        return cp;
    }

    static {
        boolean isOSGi = false;
        try {
            isOSGi = RuntimeProtoSchemaGenerator.class.getClassLoader() instanceof BundleReference;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        IS_OSGI_CONTEXT = isOSGi;
    }
}

