/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.graph.internal;

import jakarta.persistence.AttributeNode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.Subgraph;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import java.util.List;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.EntityGraphImplementor;
import org.hibernate.jpa.graph.internal.AbstractGraphNode;
import org.hibernate.jpa.graph.internal.SubgraphImpl;

public class EntityGraphImpl<T>
extends AbstractGraphNode<T>
implements EntityGraph<T>,
EntityGraphImplementor<T> {
    private final String name;
    private final EntityType<T> entityType;

    public EntityGraphImpl(String name, EntityType<T> entityType, SessionFactoryImplementor sessionFactory) {
        super(sessionFactory, true);
        this.name = name;
        this.entityType = entityType;
    }

    @Override
    public EntityGraphImpl<T> makeImmutableCopy(String name) {
        return new EntityGraphImpl<T>(name, this, false);
    }

    @Override
    public EntityGraphImpl<T> makeMutableCopy() {
        return new EntityGraphImpl<T>(this.name, this, true);
    }

    private EntityGraphImpl(String name, EntityGraphImpl<T> original, boolean mutable) {
        super(original, mutable);
        this.name = name;
        this.entityType = original.entityType;
    }

    public EntityType<T> getEntityType() {
        return this.entityType;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void addAttributeNodes(String ... attributeNames) {
        super.addAttributeNodes(attributeNames);
    }

    @Override
    @SafeVarargs
    public final void addAttributeNodes(Attribute<T, ?> ... attributes) {
        super.addAttributeNodes(attributes);
    }

    @Override
    public <X> SubgraphImpl<X> addSubgraph(Attribute<T, X> attribute) {
        return super.addSubgraph(attribute);
    }

    @Override
    public <X> SubgraphImpl<? extends X> addSubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        return super.addSubgraph(attribute, type);
    }

    @Override
    public <X> SubgraphImpl<X> addSubgraph(String attributeName) {
        return super.addSubgraph(attributeName);
    }

    @Override
    public <X> SubgraphImpl<X> addSubgraph(String attributeName, Class<X> type) {
        return super.addSubgraph(attributeName, type);
    }

    @Override
    public <X> SubgraphImpl<X> addKeySubgraph(Attribute<T, X> attribute) {
        return super.addKeySubgraph(attribute);
    }

    @Override
    public <X> SubgraphImpl<? extends X> addKeySubgraph(Attribute<T, X> attribute, Class<? extends X> type) {
        return super.addKeySubgraph(attribute, type);
    }

    @Override
    public <X> SubgraphImpl<X> addKeySubgraph(String attributeName) {
        return super.addKeySubgraph(attributeName);
    }

    @Override
    public <X> SubgraphImpl<X> addKeySubgraph(String attributeName, Class<X> type) {
        return super.addKeySubgraph(attributeName, type);
    }

    public <X> Subgraph<? extends X> addSubclassSubgraph(Class<? extends X> type) {
        throw new NotYetImplementedException();
    }

    public List<AttributeNode<?>> getAttributeNodes() {
        return super.attributeNodes();
    }

    @Override
    protected Attribute<T, ?> resolveAttribute(String attributeName) {
        Attribute attribute = this.entityType.getAttribute(attributeName);
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Given attribute name [%s] is not an attribute on this entity [%s]", attributeName, this.entityType.getName()));
        }
        return attribute;
    }

    @Override
    public boolean appliesTo(String entityName) {
        return this.appliesTo(this.getFactory().getMetamodel().entity(entityName));
    }

    @Override
    public boolean appliesTo(EntityType<? super T> entityType) {
        if (this.entityType.equals(entityType)) {
            return true;
        }
        for (IdentifiableType superType = entityType.getSupertype(); superType != null; superType = superType.getSupertype()) {
            if (!superType.equals(entityType)) continue;
            return true;
        }
        return false;
    }

    @Override
    ManagedType getManagedType() {
        return this.entityType;
    }
}

