/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.elementdesc.adapter.cdi.CDIBeanInfoAdapter;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import io.smallrye.metrics.interceptors.MetricResolver;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Intercepted;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;

@SimplyTimed
@Interceptor
@Priority(value=1010)
public class SimplyTimedInterceptor {
    private final Bean<?> bean;
    private final MetricRegistry registry;
    private final MetricResolver resolver;

    @Inject
    SimplyTimedInterceptor(@Intercepted Bean<?> bean, MetricRegistry registry) {
        this.bean = bean;
        this.registry = registry;
        this.resolver = new MetricResolver();
    }

    @AroundConstruct
    Object simplyTimedConstructor(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    Object simplyTimedMethod(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    @AroundTimeout
    Object simplyTimedTimeout(InvocationContext context) throws Exception {
        return this.timedCallable(context, context.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Member & AnnotatedElement> Object timedCallable(InvocationContext context, E element) throws Exception {
        CDIBeanInfoAdapter beanInfoAdapter = new CDIBeanInfoAdapter();
        CDIMemberInfoAdapter<E> memberInfoAdapter = new CDIMemberInfoAdapter<E>();
        MetricResolver.Of<SimplyTimed> meterResolver = this.resolver.simplyTimed(this.bean != null ? beanInfoAdapter.convert(this.bean.getBeanClass()) : beanInfoAdapter.convert(element.getDeclaringClass()), memberInfoAdapter.convert(element));
        String name = meterResolver.metricName();
        Tag[] tags = meterResolver.tags();
        MetricID metricID = new MetricID(name, tags);
        SimpleTimer timer = (SimpleTimer)this.registry.getMetrics().get(metricID);
        if (timer == null) {
            throw new IllegalStateException("No simple timer with metricID [" + metricID + "] found in registry [" + this.registry + "]");
        }
        SimpleTimer.Context time = timer.time();
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            time.stop();
        }
    }
}

