/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.export;

import org.aesh.command.export.ExportManager;
import org.aesh.parser.LineParser;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.util.Parser;

public class ExportCompletion
implements Completion {
    private static final String EXPORT = "export";
    private static final String EXPORT_SPACE = "export ";
    private final ExportManager exportManager;
    private final LineParser lineParser;

    public ExportCompletion(ExportManager manager) {
        this.exportManager = manager;
        this.lineParser = new LineParser();
    }

    public void complete(CompleteOperation completeOperation) {
        String word;
        if (EXPORT_SPACE.equals(completeOperation.getBuffer()) || EXPORT.equals(completeOperation.getBuffer().trim())) {
            completeOperation.addCompletionCandidates(this.exportManager.getAllNamesWithEquals());
            completeOperation.setOffset(completeOperation.getCursor());
        } else if (completeOperation.getBuffer().startsWith(EXPORT_SPACE)) {
            String word2 = this.lineParser.parseLine(completeOperation.getBuffer(), completeOperation.getCursor()).selectedWord().word();
            if (word2.length() > 0) {
                completeOperation.addCompletionCandidates(this.exportManager.findAllMatchingKeys(word2));
                if (Parser.containsNonEscapedDollar(word2)) {
                    int index = word2.lastIndexOf(36);
                    completeOperation.setOffset(completeOperation.getCursor() - (word2.length() - index));
                } else {
                    completeOperation.setOffset(completeOperation.getCursor() - word2.length());
                }
            }
        } else if (Parser.containsNonEscapedDollar(completeOperation.getBuffer()) && Parser.containsNonEscapedDollar(word = this.lineParser.parseLine(completeOperation.getBuffer(), completeOperation.getCursor()).selectedWord().word())) {
            completeOperation.addCompletionCandidates(this.exportManager.findAllMatchingKeys(word));
            completeOperation.setOffset(completeOperation.getCursor() - word.length());
        }
    }
}

