/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.ServletResponseWrapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.jaspi._private.ElytronMessages;
import org.wildfly.security.auth.jaspi.impl.ElytronMessageInfo;

public class ServletMessageInfo
extends ElytronMessageInfo {
    @Override
    public void setRequestMessage(Object requestMessage) {
        Assert.checkNotNullParam("requestMessage", requestMessage);
        if (!(requestMessage instanceof HttpServletRequest)) {
            throw ElytronMessages.log.invalidMessageType(requestMessage.getClass().getName(), HttpServletRequest.class.getName());
        }
        switch (this.getState()) {
            case NEW: {
                super.setRequestMessage(requestMessage);
                break;
            }
            case VALIDATE: {
                ServletRequest current = (ServletRequest)this.getRequestMessage();
                HttpServletRequest unwrapped = (HttpServletRequest)requestMessage;
                while (unwrapped != null) {
                    if (unwrapped == current) {
                        super.setRequestMessage(requestMessage);
                        return;
                    }
                    unwrapped = this.unwrap((ServletRequest)unwrapped);
                }
                throw ElytronMessages.log.messageDoesNotWrapExistingMessage(HttpServletRequest.class.getName());
            }
            case SECURE: {
                ServletRequest unwrapped = (ServletRequest)this.getRequestMessage();
                while (unwrapped != null) {
                    if (requestMessage == unwrapped) {
                        super.setRequestMessage(requestMessage);
                        return;
                    }
                    unwrapped = this.unwrap(unwrapped);
                }
                throw ElytronMessages.log.messageDoesNotUnWrapExistingMessage(HttpServletRequest.class.getName());
            }
            default: {
                throw ElytronMessages.log.messageSettingNotAllowed(HttpServletRequest.class.getName());
            }
        }
    }

    @Override
    public void setResponseMessage(Object responseMessage) {
        Assert.checkNotNullParam("responseMessage", responseMessage);
        if (!(responseMessage instanceof HttpServletResponse)) {
            throw ElytronMessages.log.invalidMessageType(responseMessage.getClass().getName(), HttpServletResponse.class.getName());
        }
        switch (this.getState()) {
            case NEW: {
                super.setResponseMessage(responseMessage);
                break;
            }
            case VALIDATE: {
                ServletResponse current = (ServletResponse)this.getResponseMessage();
                HttpServletResponse unwrapped = (HttpServletResponse)responseMessage;
                while (unwrapped != null) {
                    if (unwrapped == current) {
                        super.setResponseMessage(responseMessage);
                        return;
                    }
                    unwrapped = this.unwrap((ServletResponse)unwrapped);
                }
                throw ElytronMessages.log.messageDoesNotWrapExistingMessage(HttpServletResponse.class.getName());
            }
            case SECURE: {
                ServletResponse unwrapped = (ServletResponse)this.getRequestMessage();
                while (unwrapped != null) {
                    if (responseMessage == unwrapped) {
                        super.setResponseMessage(responseMessage);
                        return;
                    }
                    unwrapped = this.unwrap(unwrapped);
                }
                throw ElytronMessages.log.messageDoesNotUnWrapExistingMessage(HttpServletResponse.class.getName());
            }
            default: {
                throw ElytronMessages.log.messageSettingNotAllowed(HttpServletResponse.class.getName());
            }
        }
    }

    private ServletRequest unwrap(ServletRequest servletRequest) {
        if (servletRequest instanceof ServletRequestWrapper) {
            return ((ServletRequestWrapper)servletRequest).getRequest();
        }
        return null;
    }

    private ServletResponse unwrap(ServletResponse servletResponse) {
        if (servletResponse instanceof ServletResponseWrapper) {
            return ((ServletResponseWrapper)servletResponse).getResponse();
        }
        return null;
    }
}

