/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.ws.rs.WebApplicationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import org.jboss.resteasy.cdi.Utils;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.weld.proxy.WeldClientProxy;

public class CdiPropertyInjector
implements PropertyInjector {
    private PropertyInjector delegate;
    private Class<?> clazz;
    private boolean injectorEnabled = true;

    public CdiPropertyInjector(PropertyInjector delegate, Class<?> clazz, Map<Class<?>, Type> sessionBeanInterface, BeanManager manager) {
        this.delegate = delegate;
        this.clazz = clazz;
        if (sessionBeanInterface.containsKey(clazz)) {
            this.injectorEnabled = false;
        }
        if (!manager.getBeans(clazz, new Annotation[0]).isEmpty() && Utils.isJaxrsComponent(clazz)) {
            this.injectorEnabled = false;
        }
    }

    public void inject(Object target) {
        if (this.injectorEnabled) {
            this.delegate.inject(target);
        }
    }

    public void inject(HttpRequest request, HttpResponse response, Object target) throws Failure, WebApplicationException, ApplicationException {
        if (this.injectorEnabled) {
            Object actualTarget = target;
            if (actualTarget instanceof WeldClientProxy) {
                actualTarget = ((WeldClientProxy)target).getMetadata().getContextualInstance();
            }
            this.delegate.inject(request, response, actualTarget);
        }
    }

    public String toString() {
        return "CdiPropertyInjector (enabled: " + this.injectorEnabled + ") for " + this.clazz;
    }
}

