/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.sse.SseEventSink;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.resteasy.annotations.Stream;
import org.jboss.resteasy.core.AsyncResponseConsumer;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.PostResourceMethodInvokers;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.core.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.core.interception.JaxrsInterceptorRegistryListener;
import org.jboss.resteasy.core.interception.PostMatchContainerRequestContext;
import org.jboss.resteasy.plugins.server.resourcefactory.JndiComponentResourceFactory;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.specimpl.BuiltResponseEntityNotBacked;
import org.jboss.resteasy.spi.AsyncResponseProvider;
import org.jboss.resteasy.spi.AsyncStreamProvider;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.spi.metadata.MethodParameter;
import org.jboss.resteasy.spi.metadata.Parameter;
import org.jboss.resteasy.spi.metadata.ResourceMethod;
import org.jboss.resteasy.spi.statistics.MethodStatisticsLogger;
import org.jboss.resteasy.spi.validation.GeneralValidator;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;
import org.jboss.resteasy.statistics.StatisticsControllerImpl;
import org.jboss.resteasy.util.DynamicFeatureContextDelegate;
import org.jboss.resteasy.util.FeatureContextDelegate;

public class ResourceMethodInvoker
implements ResourceInvoker,
JaxrsInterceptorRegistryListener {
    protected MethodInjector methodInjector;
    protected InjectorFactory injector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory parentProviderFactory;
    protected ResteasyProviderFactory resourceMethodProviderFactory;
    protected ResourceMethod method;
    protected Annotation[] methodAnnotations;
    protected ContainerRequestFilter[] requestFilters;
    protected ContainerResponseFilter[] responseFilters;
    protected WriterInterceptor[] writerInterceptors;
    protected ConcurrentHashMap<String, AtomicLong> stats = new ConcurrentHashMap();
    protected GeneralValidator validator;
    protected boolean isValidatable;
    protected boolean methodIsValidatable;
    protected AsyncResponseProvider asyncResponseProvider;
    AsyncStreamProvider asyncStreamProvider;
    protected boolean isSse;
    protected ResourceInfo resourceInfo;
    protected boolean expectsBody;
    protected MethodStatisticsLogger methodStatisticsLogger;

    public ResourceMethodInvoker(ResourceMethod method, InjectorFactory injector, ResourceFactory resource, ResteasyProviderFactory providerFactory) {
        this.injector = injector;
        this.resource = resource;
        this.parentProviderFactory = providerFactory;
        this.method = method;
        this.methodAnnotations = this.method.getAnnotatedMethod().getAnnotations();
        StatisticsControllerImpl cfr_ignored_0 = (StatisticsControllerImpl)providerFactory.getStatisticsController();
        this.methodStatisticsLogger = StatisticsControllerImpl.EMPTY;
        this.resourceInfo = new ResourceInfo(){

            public Method getResourceMethod() {
                return ResourceMethodInvoker.this.method.getMethod();
            }

            public Class<?> getResourceClass() {
                return ResourceMethodInvoker.this.method.getResourceClass().getClazz();
            }
        };
        this.resourceMethodProviderFactory = new ResteasyProviderFactory(providerFactory);
        for (DynamicFeature feature : providerFactory.getServerDynamicFeatures()) {
            feature.configure(this.resourceInfo, (FeatureContext)new DynamicFeatureContextDelegate(this.resourceMethodProviderFactory));
        }
        this.methodInjector = injector.createMethodInjector(method, this.resourceMethodProviderFactory);
        this.expectsBody = this.methodInjector.expectsBody();
        this.requestFilters = this.resourceMethodProviderFactory.getContainerRequestFilterRegistry().postMatch(method.getResourceClass().getClazz(), method.getAnnotatedMethod());
        this.responseFilters = (ContainerResponseFilter[])this.resourceMethodProviderFactory.getContainerResponseFilterRegistry().postMatch(method.getResourceClass().getClazz(), method.getAnnotatedMethod());
        this.writerInterceptors = (WriterInterceptor[])this.resourceMethodProviderFactory.getServerWriterInterceptorRegistry().postMatch(method.getResourceClass().getClazz(), method.getAnnotatedMethod());
        providerFactory.getContainerRequestFilterRegistry().getListeners().add(this);
        providerFactory.getContainerResponseFilterRegistry().getListeners().add(this);
        providerFactory.getServerWriterInterceptorRegistry().getListeners().add(this);
        ContextResolver<GeneralValidator> resolver = providerFactory.getContextResolver(GeneralValidator.class, MediaType.WILDCARD_TYPE);
        if (resolver != null) {
            this.validator = (GeneralValidator)providerFactory.getContextResolver(GeneralValidator.class, MediaType.WILDCARD_TYPE).getContext(null);
        }
        if (this.validator != null) {
            Class<?> clazz = null;
            clazz = resource != null && resource.getScannableClass() != null ? resource.getScannableClass() : this.getMethod().getDeclaringClass();
            this.isValidatable = resource instanceof JndiComponentResourceFactory ? true : (this.validator instanceof GeneralValidatorCDI ? ((GeneralValidatorCDI)GeneralValidatorCDI.class.cast(this.validator)).isValidatable(clazz, injector) : this.validator.isValidatable(clazz));
            this.methodIsValidatable = this.validator.isMethodValidatable(this.getMethod());
        }
        this.asyncResponseProvider = this.resourceMethodProviderFactory.getAsyncResponseProvider(method.getReturnType());
        if (this.asyncResponseProvider == null) {
            this.asyncStreamProvider = this.resourceMethodProviderFactory.getAsyncStreamProvider(method.getReturnType());
        }
        if (this.isSseResourceMethod(method)) {
            this.isSse = true;
            method.markAsynchronous();
        }
    }

    private boolean isSseResourceMethod(ResourceMethod resourceMethod) {
        boolean onlyProduceServerSentEventsMediaType;
        MediaType[] producedMediaTypes = resourceMethod.getProduces();
        boolean bl = onlyProduceServerSentEventsMediaType = producedMediaTypes != null && producedMediaTypes.length == 1 && MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(producedMediaTypes[0]);
        if (!onlyProduceServerSentEventsMediaType) {
            return false;
        }
        MethodParameter[] resourceMethodParameters = resourceMethod.getParams();
        if (resourceMethodParameters != null) {
            for (MethodParameter resourceMethodParameter : resourceMethodParameters) {
                if (!Parameter.ParamType.CONTEXT.equals((Object)resourceMethodParameter.getParamType()) || !SseEventSink.class.equals(resourceMethodParameter.getType())) continue;
                return true;
            }
        }
        if (this.asyncStreamProvider != null) {
            for (Annotation annotation : resourceMethod.getAnnotatedMethod().getAnnotations()) {
                if (annotation.annotationType() != Stream.class) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void cleanup() {
        this.parentProviderFactory.getContainerRequestFilterRegistry().getListeners().remove(this);
        this.parentProviderFactory.getContainerResponseFilterRegistry().getListeners().remove(this);
        this.parentProviderFactory.getServerWriterInterceptorRegistry().getListeners().remove(this);
        for (ValueInjector param : this.methodInjector.getParams()) {
            if (!(param instanceof MessageBodyParameterInjector)) continue;
            this.parentProviderFactory.getServerReaderInterceptorRegistry().getListeners().remove(param);
        }
    }

    @Override
    public void registryUpdated(JaxrsInterceptorRegistry registry) {
        this.resourceMethodProviderFactory = new ResteasyProviderFactory(this.parentProviderFactory);
        for (DynamicFeature feature : this.parentProviderFactory.getServerDynamicFeatures()) {
            feature.configure(this.resourceInfo, (FeatureContext)new FeatureContextDelegate(this.resourceMethodProviderFactory));
        }
        if (registry.getIntf().equals(WriterInterceptor.class)) {
            this.writerInterceptors = (WriterInterceptor[])this.resourceMethodProviderFactory.getServerWriterInterceptorRegistry().postMatch(this.method.getResourceClass().getClazz(), this.method.getAnnotatedMethod());
        } else if (registry.getIntf().equals(ContainerRequestFilter.class)) {
            this.requestFilters = this.resourceMethodProviderFactory.getContainerRequestFilterRegistry().postMatch(this.method.getResourceClass().getClazz(), this.method.getAnnotatedMethod());
        } else if (registry.getIntf().equals(ContainerResponseFilter.class)) {
            this.responseFilters = (ContainerResponseFilter[])this.resourceMethodProviderFactory.getContainerResponseFilterRegistry().postMatch(this.method.getResourceClass().getClazz(), this.method.getAnnotatedMethod());
        }
    }

    protected void incrementMethodCount(String httpMethod) {
        AtomicLong old;
        AtomicLong stat = this.stats.get(httpMethod);
        if (stat == null && (old = this.stats.putIfAbsent(httpMethod, stat = new AtomicLong())) != null) {
            stat = old;
        }
        stat.incrementAndGet();
    }

    public Map<String, AtomicLong> getStats() {
        return this.stats;
    }

    public ContainerRequestFilter[] getRequestFilters() {
        return this.requestFilters;
    }

    public ContainerResponseFilter[] getResponseFilters() {
        return this.responseFilters;
    }

    public WriterInterceptor[] getWriterInterceptors() {
        return this.writerInterceptors;
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public Class<?> getResourceClass() {
        return this.method.getResourceClass().getClazz();
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Annotation[] getMethodAnnotations() {
        return this.methodAnnotations;
    }

    @Override
    public Method getMethod() {
        return this.method.getMethod();
    }

    public Object invokeDryRun(HttpRequest request, HttpResponse response) {
        Object target = this.resource.createResource(request, response, this.resourceMethodProviderFactory);
        return this.invokeDryRun(request, response, target);
    }

    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response) {
        Object target = this.resource.createResource(request, response, this.resourceMethodProviderFactory);
        return this.invoke(request, response, target);
    }

    public Object invokeDryRun(HttpRequest request, HttpResponse response, Object target) {
        request.setAttribute(ResourceMethodInvoker.class.getName(), this);
        this.incrementMethodCount(request.getHttpMethod());
        ResteasyUriInfo uriInfo = request.getUri();
        if (this.method.getPath() != null) {
            uriInfo.pushMatchedURI(uriInfo.getMatchingPath());
        }
        uriInfo.pushCurrentResource(target);
        Object rtn = this.invokeOnTargetDryRun(request, response, target);
        return rtn;
    }

    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response, Object target) {
        request.setAttribute(ResourceMethodInvoker.class.getName(), this);
        this.incrementMethodCount(request.getHttpMethod());
        ResteasyUriInfo uriInfo = request.getUri();
        if (this.method.getPath() != null) {
            uriInfo.pushMatchedURI(uriInfo.getMatchingPath());
        }
        uriInfo.pushCurrentResource(target);
        BuiltResponse rtn = this.invokeOnTarget(request, response, target);
        return rtn;
    }

    protected Object invokeOnTargetDryRun(HttpRequest request, HttpResponse response, Object target) {
        ResteasyProviderFactory.pushContext(ResourceInfo.class, this.resourceInfo);
        ResteasyProviderFactory.pushContext(Configuration.class, this.resourceMethodProviderFactory);
        Object rtn = null;
        try {
            rtn = this.internalInvokeOnTarget(request, response, target);
        }
        catch (RuntimeException ex) {
            throw new ProcessingException((Throwable)ex);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuiltResponse invokeOnTarget(HttpRequest request, HttpResponse response, Object target) {
        long msTimeStamp = this.methodStatisticsLogger.timestamp();
        try {
            ResteasyProviderFactory.pushContext(ResourceInfo.class, this.resourceInfo);
            ResteasyProviderFactory.pushContext(Configuration.class, this.resourceMethodProviderFactory);
            PostMatchContainerRequestContext requestContext = new PostMatchContainerRequestContext(request, this, this.requestFilters, () -> this.invokeOnTargetAfterFilter(request, response, target));
            BuiltResponse builtResponse = requestContext.filter();
            return builtResponse;
        }
        finally {
            this.methodStatisticsLogger.duration(msTimeStamp);
        }
    }

    protected BuiltResponse invokeOnTargetAfterFilter(HttpRequest request, HttpResponse response, Object target) {
        if (this.validator != null) {
            if (this.isValidatable) {
                this.validator.validate(request, target, new Class[0]);
            }
            if (this.methodIsValidatable) {
                request.setAttribute(GeneralValidator.class.getName(), this.validator);
            } else if (this.isValidatable) {
                this.validator.checkViolations(request);
            }
        }
        AsyncResponseConsumer asyncResponseConsumer = null;
        if (this.asyncResponseProvider != null) {
            asyncResponseConsumer = AsyncResponseConsumer.makeAsyncResponseConsumer(this, this.asyncResponseProvider);
        } else if (this.asyncStreamProvider != null) {
            asyncResponseConsumer = AsyncResponseConsumer.makeAsyncResponseConsumer(this, this.asyncStreamProvider);
        }
        Object rtn = null;
        try {
            rtn = this.internalInvokeOnTarget(request, response, target);
        }
        catch (RuntimeException ex) {
            if (asyncResponseConsumer != null) {
                try {
                    AsyncResponseConsumer consumer = asyncResponseConsumer;
                    asyncResponseConsumer.internalResume(ex, t -> consumer.complete(ex));
                }
                catch (UnhandledException x) {
                    request.getAsyncContext().getAsyncResponse().completionCallbacks(ex);
                    throw x;
                }
                return null;
            }
            if (request.getAsyncContext().isSuspended()) {
                try {
                    request.getAsyncContext().getAsyncResponse().resume(ex);
                }
                catch (Exception e) {
                    LogMessages.LOGGER.errorResumingFailedAsynchOperation(e);
                }
                return null;
            }
            throw ex;
        }
        if (asyncResponseConsumer != null) {
            asyncResponseConsumer.subscribe(rtn);
            return null;
        }
        if (request.getAsyncContext().isSuspended()) {
            if (this.method.isAsynchronous()) {
                return null;
            }
            this.initializeAsync(request.getAsyncContext().getAsyncResponse());
            request.getAsyncContext().getAsyncResponse().resume(rtn);
            return null;
        }
        if (request.wasForwarded()) {
            return null;
        }
        if (rtn == null || this.method.getReturnType().equals(Void.TYPE)) {
            BuiltResponse build = (BuiltResponse)Response.noContent().build();
            build.addMethodAnnotations(this.getMethodAnnotations());
            return build;
        }
        if (Response.class.isAssignableFrom(this.method.getReturnType()) || rtn instanceof Response) {
            if (!(rtn instanceof BuiltResponse)) {
                Response r = (Response)rtn;
                Headers<Object> metadata = new Headers<Object>();
                metadata.putAll(r.getMetadata());
                rtn = new BuiltResponseEntityNotBacked(r.getStatus(), r.getStatusInfo().getReasonPhrase(), metadata, r.getEntity(), null);
            }
            BuiltResponse rtn1 = (BuiltResponse)((Object)rtn);
            rtn1.addMethodAnnotations(this.getMethodAnnotations());
            if (rtn1.getGenericType() == null) {
                if (this.getMethod().getReturnType().equals(Response.class)) {
                    rtn1.setGenericType(rtn1.getEntityClass());
                } else {
                    rtn1.setGenericType(this.method.getGenericReturnType());
                }
            }
            return rtn1;
        }
        Response.ResponseBuilder builder = Response.ok((Object)rtn);
        BuiltResponse jaxrsResponse = (BuiltResponse)builder.build();
        if (jaxrsResponse.getGenericType() == null) {
            if (this.getMethod().getReturnType().equals(Response.class)) {
                jaxrsResponse.setGenericType(jaxrsResponse.getEntityClass());
            } else {
                jaxrsResponse.setGenericType(this.method.getGenericReturnType());
            }
        }
        jaxrsResponse.addMethodAnnotations(this.getMethodAnnotations());
        return jaxrsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internalInvokeOnTarget(HttpRequest request, HttpResponse response, Object target) {
        PostResourceMethodInvokers postResourceMethodInvokers = ResteasyProviderFactory.getContextData(PostResourceMethodInvokers.class);
        try {
            Object toReturn = this.methodInjector.invoke(request, response, target);
            if (postResourceMethodInvokers != null) {
                postResourceMethodInvokers.getInvokers().forEach(e -> e.invoke());
            }
            Object object = toReturn;
            return object;
        }
        finally {
            if (postResourceMethodInvokers != null) {
                postResourceMethodInvokers.clear();
            }
        }
    }

    public void initializeAsync(ResteasyAsynchronousResponse asyncResponse) {
        asyncResponse.setAnnotations(this.method.getAnnotatedMethod().getAnnotations());
        asyncResponse.setWriterInterceptors(this.writerInterceptors);
        asyncResponse.setResponseFilters(this.responseFilters);
        asyncResponse.setMethod(this);
    }

    public boolean doesProduce(List<? extends MediaType> accepts) {
        if (accepts == null || accepts.size() == 0) {
            return true;
        }
        if (this.method.getProduces().length == 0) {
            return true;
        }
        for (MediaType mediaType : accepts) {
            for (MediaType type : this.method.getProduces()) {
                if (!type.isCompatible(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean doesConsume(MediaType contentType) {
        boolean matches = false;
        if (this.method.getConsumes().length == 0 || contentType == null && !this.expectsBody) {
            return true;
        }
        if (contentType == null) {
            contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        for (MediaType type : this.method.getConsumes()) {
            if (!type.isCompatible(contentType)) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public MediaType resolveContentType(HttpRequest in, Object entity) {
        MediaType chosen = (MediaType)in.getAttribute("RESTEASY_CHOSEN_ACCEPT");
        if (chosen != null && !chosen.equals((Object)MediaType.WILDCARD_TYPE)) {
            return chosen;
        }
        List accepts = in.getHttpHeaders().getAcceptableMediaTypes();
        if (accepts == null || accepts.size() == 0) {
            if (this.method.getProduces().length == 0) {
                return MediaType.WILDCARD_TYPE;
            }
            return this.method.getProduces()[0];
        }
        if (this.method.getProduces().length == 0) {
            return this.resolveContentTypeByAccept(accepts, entity);
        }
        for (MediaType accept : accepts) {
            for (MediaType type : this.method.getProduces()) {
                if (!type.isCompatible(accept)) continue;
                return type;
            }
        }
        return MediaType.WILDCARD_TYPE;
    }

    protected MediaType resolveContentTypeByAccept(List<MediaType> accepts, Object entity) {
        if (accepts == null || accepts.size() == 0 || entity == null) {
            return MediaType.WILDCARD_TYPE;
        }
        Class clazz = entity.getClass();
        Type type = this.method.getGenericReturnType();
        if (entity instanceof GenericEntity) {
            GenericEntity gen = (GenericEntity)entity;
            clazz = gen.getRawType();
            type = gen.getType();
        }
        for (MediaType accept : accepts) {
            if (this.resourceMethodProviderFactory.getMessageBodyWriter(clazz, type, this.method.getAnnotatedMethod().getAnnotations(), accept) == null) continue;
            return accept;
        }
        return MediaType.WILDCARD_TYPE;
    }

    public Set<String> getHttpMethods() {
        return this.method.getHttpMethods();
    }

    public MediaType[] getProduces() {
        return this.method.getProduces();
    }

    public MediaType[] getConsumes() {
        return this.method.getConsumes();
    }

    public boolean isSse() {
        return this.isSse;
    }

    public void markMethodAsAsync() {
        this.method.markAsynchronous();
    }

    @Override
    public void setMethodStatisticsLogger(MethodStatisticsLogger msLogger) {
        this.methodStatisticsLogger = msLogger;
    }

    @Override
    public MethodStatisticsLogger getMethodStatisticsLogger() {
        return this.methodStatisticsLogger;
    }
}

