/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jberet._private.BatchLogger;
import org.jberet.job.model.Job;
import org.jberet.repository.ApplicationAndJobName;
import org.jberet.repository.JobRepository;
import org.jberet.repository.SoftReference;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.util.BatchUtil;
import org.wildfly.security.manager.WildFlySecurityManager;

public abstract class AbstractRepository
implements JobRepository {
    final ConcurrentMap<ApplicationAndJobName, SoftReference<Job, ApplicationAndJobName>> jobs = new ConcurrentHashMap<ApplicationAndJobName, SoftReference<Job, ApplicationAndJobName>>();
    final ReferenceQueue<Job> jobReferenceQueue = new ReferenceQueue();

    abstract void insertJobInstance(JobInstanceImpl var1);

    abstract void insertJobExecution(JobExecutionImpl var1);

    abstract void insertStepExecution(StepExecutionImpl var1, JobExecutionImpl var2);

    @Override
    public void addJob(ApplicationAndJobName applicationAndJobName, Job job) {
        Reference<Job> x;
        while ((x = this.jobReferenceQueue.poll()) != null) {
            SoftReference entry = (SoftReference)x;
            this.jobs.remove(entry.getKey());
        }
        this.jobs.put(applicationAndJobName, new SoftReference<Job, ApplicationAndJobName>(job, this.jobReferenceQueue, applicationAndJobName));
    }

    @Override
    public Job getJob(ApplicationAndJobName applicationAndJobName) {
        SoftReference jobSoftReference = (SoftReference)this.jobs.get(applicationAndJobName);
        return jobSoftReference != null ? (Job)jobSoftReference.get() : null;
    }

    @Override
    public boolean jobExists(String jobName) {
        for (ApplicationAndJobName e : this.jobs.keySet()) {
            if (!e.jobName.equals(jobName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getJobNames() {
        HashSet<String> jobNames = new HashSet<String>();
        for (ApplicationAndJobName e : this.jobs.keySet()) {
            jobNames.add(e.jobName);
        }
        return jobNames;
    }

    @Override
    public void removeJob(String jobId) {
        Iterator it = this.jobs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            if (!((ApplicationAndJobName)next.getKey()).jobName.equals(jobId)) continue;
            BatchLogger.LOGGER.removing("Job", jobId);
            it.remove();
        }
    }

    @Override
    public StepExecutionImpl createStepExecution(String stepName) {
        return new StepExecutionImpl(stepName);
    }

    @Override
    public void addStepExecution(JobExecutionImpl jobExecution, StepExecutionImpl stepExecution) {
        jobExecution.addStepExecution(stepExecution);
        this.insertStepExecution(stepExecution, jobExecution);
    }

    @Override
    public void savePersistentData(JobExecution jobExecution, AbstractStepExecution stepOrPartitionExecution) {
    }

    @Override
    public void updateJobExecution(JobExecutionImpl jobExecution, boolean fullUpdate, boolean saveJobParameters) {
        jobExecution.setLastUpdatedTime(System.currentTimeMillis());
    }

    @Override
    public void addPartitionExecution(StepExecutionImpl enclosingStepExecution, PartitionExecutionImpl partitionExecution) {
        enclosingStepExecution.getPartitionExecutions().add(partitionExecution);
    }

    @Override
    public List<PartitionExecutionImpl> getPartitionExecutions(long stepExecutionId, StepExecutionImpl stepExecution, boolean notCompletedOnly, ClassLoader classLoader) {
        if (stepExecution != null) {
            List<PartitionExecutionImpl> partitionExecutions = stepExecution.getPartitionExecutions();
            if (partitionExecutions == null) {
                return Collections.emptyList();
            }
            if (partitionExecutions.isEmpty() || !notCompletedOnly) {
                return partitionExecutions;
            }
            ArrayList<PartitionExecutionImpl> result = new ArrayList<PartitionExecutionImpl>();
            for (PartitionExecutionImpl sei : partitionExecutions) {
                if (sei.getBatchStatus() == BatchStatus.COMPLETED) continue;
                result.add(sei);
            }
            return result;
        }
        return null;
    }

    private static <T extends Serializable> T clone(final T object) {
        if (WildFlySecurityManager.isChecking()) {
            return (T)((Serializable)AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    return BatchUtil.clone(object);
                }
            }));
        }
        return BatchUtil.clone(object);
    }
}

