/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import io.netty.channel.Channel;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.ListenerRegistry;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import io.undertow.util.FlexBase64;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.ha.HAManager;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.HTTPAcceptorDefinition;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.netty.transport.WrappingXnioSocketChannel;

public class HTTPUpgradeService
implements org.jboss.msc.service.Service<HTTPUpgradeService> {
    private final String activeMQServerName;
    private final String acceptorName;
    private final String httpListenerName;
    private final Supplier<ChannelUpgradeHandler> upgradeSupplier;
    private final Supplier<ListenerRegistry> listenerRegistrySupplier;
    private HttpUpgradeListener httpUpgradeListener;
    private ListenerRegistry.HttpUpgradeMetadata httpUpgradeMetadata;

    public HTTPUpgradeService(String activeMQServerName, String acceptorName, String httpListenerName, Supplier<ChannelUpgradeHandler> upgradeSupplier, Supplier<ListenerRegistry> listenerRegistrySupplier) {
        this.activeMQServerName = activeMQServerName;
        this.acceptorName = acceptorName;
        this.httpListenerName = httpListenerName;
        this.upgradeSupplier = upgradeSupplier;
        this.listenerRegistrySupplier = listenerRegistrySupplier;
    }

    public static void installService(CapabilityServiceTarget target, String activeMQServerName, String acceptorName, String httpListenerName) {
        CapabilityServiceBuilder sb = target.addCapability(HTTPAcceptorDefinition.CAPABILITY);
        sb.provides(new ServiceName[]{MessagingServices.getHttpUpgradeServiceName(activeMQServerName, acceptorName)});
        Supplier upgradeSupplier = sb.requiresCapability("org.wildfly.undertow.listener.http-upgrade-registry", ChannelUpgradeHandler.class, new String[]{httpListenerName});
        Supplier listenerRegistrySupplier = sb.requiresCapability("org.wildfly.remoting.http-listener-registry", ListenerRegistry.class, new String[0]);
        sb.requires(ActiveMQActivationService.getServiceName(MessagingServices.getActiveMQServiceName(activeMQServerName)));
        HTTPUpgradeService service = new HTTPUpgradeService(activeMQServerName, acceptorName, httpListenerName, upgradeSupplier, listenerRegistrySupplier);
        sb.setInitialMode(ServiceController.Mode.PASSIVE);
        sb.setInstance((Service)service);
        sb.install();
    }

    public void start(StartContext context) throws StartException {
        ListenerRegistry listenerRegistry = this.listenerRegistrySupplier.get();
        ListenerRegistry.Listener listenerInfo = listenerRegistry.getListener(this.httpListenerName);
        assert (listenerInfo != null);
        this.httpUpgradeMetadata = new ListenerRegistry.HttpUpgradeMetadata(this.getProtocol(), "core");
        listenerInfo.addHttpUpgradeMetadata(this.httpUpgradeMetadata);
        MessagingLogger.ROOT_LOGGER.registeredHTTPUpgradeHandler("activemq-remoting", this.acceptorName);
        ServiceController activeMQService = context.getController().getServiceContainer().getService(MessagingServices.getActiveMQServiceName(this.activeMQServerName));
        final ActiveMQServer activeMQServer = (ActiveMQServer)ActiveMQServer.class.cast(activeMQService.getValue());
        this.httpUpgradeListener = HTTPUpgradeService.switchToMessagingProtocol(activeMQServer, this.acceptorName, this.getProtocol());
        this.upgradeSupplier.get().addProtocol(this.getProtocol(), this.httpUpgradeListener, new HttpUpgradeHandshake(){

            public boolean handleUpgrade(HttpServerExchange exchange) throws IOException {
                String secretKey = exchange.getRequestHeaders().getFirst(HTTPUpgradeService.this.getSecKeyHeader());
                if (secretKey == null) {
                    throw MessagingLogger.ROOT_LOGGER.upgradeRequestMissingKey();
                }
                ActiveMQServer server = HTTPUpgradeService.selectServer(exchange, activeMQServer);
                if (server == null) {
                    return false;
                }
                RemotingService remotingService = server.getRemotingService();
                if (!server.isActive() || !remotingService.isStarted()) {
                    return false;
                }
                String endpoint = exchange.getRequestHeaders().getFirst(HTTPUpgradeService.this.getHttpUpgradeEndpointKey());
                if (endpoint == null || endpoint.equals(HTTPUpgradeService.this.acceptorName)) {
                    String response = this.createExpectedResponse("CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD", secretKey);
                    exchange.getResponseHeaders().put(HttpString.tryFromString((String)HTTPUpgradeService.this.getSecAcceptHeader()), response);
                    return true;
                }
                return false;
            }

            private String createExpectedResponse(String magicNumber, String secretKey) throws IOException {
                try {
                    String concat = secretKey + magicNumber;
                    MessageDigest digest = MessageDigest.getInstance("SHA1");
                    digest.update(concat.getBytes(StandardCharsets.UTF_8));
                    byte[] bytes = digest.digest();
                    return FlexBase64.encodeString((byte[])bytes, (boolean)false);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException(e);
                }
            }
        });
    }

    private static ActiveMQServer selectServer(HttpServerExchange exchange, ActiveMQServer rootServer) {
        HAManager haManager;
        String activemqServerName = exchange.getRequestHeaders().getFirst("activemqServerName");
        if (activemqServerName == null) {
            return rootServer;
        }
        ClusterManager clusterManager = rootServer.getClusterManager();
        if (clusterManager != null && (haManager = clusterManager.getHAManager()) != null) {
            for (Map.Entry entry : haManager.getBackupServers().entrySet()) {
                if (!((String)entry.getKey()).equals(activemqServerName)) continue;
                return (ActiveMQServer)entry.getValue();
            }
        }
        if (activemqServerName.equals(rootServer.getConfiguration().getName())) {
            return rootServer;
        }
        return null;
    }

    public void stop(StopContext context) {
        this.listenerRegistrySupplier.get().getListener(this.httpListenerName).removeHttpUpgradeMetadata(this.httpUpgradeMetadata);
        this.httpUpgradeMetadata = null;
        this.upgradeSupplier.get().removeProtocol(this.getProtocol(), this.httpUpgradeListener);
        this.httpUpgradeListener = null;
    }

    public HTTPUpgradeService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static HttpUpgradeListener switchToMessagingProtocol(final ActiveMQServer activemqServer, final String acceptorName, final String protocolName) {
        return new HttpUpgradeListener(){

            public void handleUpgrade(StreamConnection streamConnection, final HttpServerExchange exchange) {
                ChannelListener<StreamConnection> listener = new ChannelListener<StreamConnection>(){

                    public void handleEvent(StreamConnection connection) {
                        MessagingLogger.ROOT_LOGGER.debugf("Switching to %s protocol for %s http-acceptor", protocolName, acceptorName);
                        ActiveMQServer server = HTTPUpgradeService.selectServer(exchange, activemqServer);
                        RemotingService remotingService = server.getRemotingService();
                        if (!server.isActive() || !remotingService.isStarted()) {
                            IoUtils.safeClose((Closeable)connection);
                            return;
                        }
                        NettyAcceptor acceptor = (NettyAcceptor)remotingService.getAcceptor(acceptorName);
                        WrappingXnioSocketChannel channel = new WrappingXnioSocketChannel(connection);
                        try {
                            acceptor.transfer((Channel)channel);
                            connection.getSourceChannel().resumeReads();
                        }
                        catch (IllegalStateException e) {
                            IoUtils.safeClose((Closeable)connection);
                        }
                    }
                };
                ChannelListeners.invokeChannelListener((java.nio.channels.Channel)streamConnection, (ChannelListener)listener);
            }
        };
    }

    protected String getProtocol() {
        return "activemq-remoting";
    }

    protected String getSecKeyHeader() {
        return "Sec-ActiveMQRemoting-Key";
    }

    protected String getSecAcceptHeader() {
        return "Sec-ActiveMQRemoting-Accept";
    }

    protected String getHttpUpgradeEndpointKey() {
        return "httpUpgradeEndpoint";
    }

    static class LegacyHttpUpgradeService
    extends HTTPUpgradeService {
        public static void installService(OperationContext context, String activeMQServerName, String acceptorName, String httpListenerName) {
            CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(RuntimeCapability.Builder.of((String)MessagingServices.getLegacyHttpUpgradeServiceName(activeMQServerName, acceptorName).getCanonicalName(), (boolean)false, LegacyHttpUpgradeService.class).build());
            Supplier upgradeSupplier = sb.requiresCapability("org.wildfly.undertow.listener.http-upgrade-registry", ChannelUpgradeHandler.class, new String[]{httpListenerName});
            Supplier listenerRegistrySupplier = sb.requiresCapability("org.wildfly.remoting.http-listener-registry", ListenerRegistry.class, new String[0]);
            sb.requires(ActiveMQActivationService.getServiceName(MessagingServices.getActiveMQServiceName(activeMQServerName)));
            sb.setInitialMode(ServiceController.Mode.PASSIVE);
            LegacyHttpUpgradeService service = new LegacyHttpUpgradeService(activeMQServerName, acceptorName, httpListenerName, upgradeSupplier, listenerRegistrySupplier);
            sb.setInstance((Service)service);
            sb.install();
        }

        private LegacyHttpUpgradeService(String activeMQServerName, String acceptorName, String httpListenerName, Supplier<ChannelUpgradeHandler> upgradeSupplier, Supplier<ListenerRegistry> listenerRegistrySupplier) {
            super(activeMQServerName, acceptorName, httpListenerName, upgradeSupplier, listenerRegistrySupplier);
        }

        @Override
        protected String getProtocol() {
            return "hornetq-remoting";
        }

        @Override
        protected String getHttpUpgradeEndpointKey() {
            return "http-upgrade-endpoint";
        }

        @Override
        protected String getSecKeyHeader() {
            return "Sec-HornetQRemoting-Key";
        }

        @Override
        protected String getSecAcceptHeader() {
            return "Sec-HornetQRemoting-Accept";
        }
    }
}

