/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.deployment.injection;

import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

abstract class JMSContextWrapper
implements JMSContext {
    JMSContextWrapper() {
    }

    abstract JMSContext getDelegate();

    public JMSContext createContext(int sessionMode) {
        return this.getDelegate().createContext(sessionMode);
    }

    public JMSProducer createProducer() {
        return this.getDelegate().createProducer();
    }

    public String getClientID() {
        return this.getDelegate().getClientID();
    }

    public void setClientID(String clientID) {
        throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
    }

    public ConnectionMetaData getMetaData() {
        return this.getDelegate().getMetaData();
    }

    public ExceptionListener getExceptionListener() {
        return this.getDelegate().getExceptionListener();
    }

    public void setExceptionListener(ExceptionListener listener) {
        throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
    }

    public void start() {
        throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
    }

    public void stop() {
        throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
    }

    public void setAutoStart(boolean autoStart) {
        throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
    }

    public boolean getAutoStart() {
        return this.getDelegate().getAutoStart();
    }

    public void close() {
        throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
    }

    public BytesMessage createBytesMessage() {
        return this.getDelegate().createBytesMessage();
    }

    public MapMessage createMapMessage() {
        return this.getDelegate().createMapMessage();
    }

    public Message createMessage() {
        return this.getDelegate().createMessage();
    }

    public ObjectMessage createObjectMessage() {
        return this.getDelegate().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return this.getDelegate().createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() {
        return this.getDelegate().createStreamMessage();
    }

    public TextMessage createTextMessage() {
        return this.getDelegate().createTextMessage();
    }

    public TextMessage createTextMessage(String text) {
        return this.getDelegate().createTextMessage(text);
    }

    public boolean getTransacted() {
        return this.getDelegate().getTransacted();
    }

    public int getSessionMode() {
        return this.getDelegate().getSessionMode();
    }

    public void commit() {
        throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
    }

    public void rollback() {
        throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
    }

    public void recover() {
        throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
    }

    public JMSConsumer createConsumer(Destination destination) {
        return this.getDelegate().createConsumer(destination);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        return this.getDelegate().createConsumer(destination, messageSelector);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        return this.getDelegate().createConsumer(destination, messageSelector, noLocal);
    }

    public Queue createQueue(String queueName) {
        return this.getDelegate().createQueue(queueName);
    }

    public Topic createTopic(String topicName) {
        return this.getDelegate().createTopic(topicName);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        return this.getDelegate().createDurableConsumer(topic, name);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        return this.getDelegate().createDurableConsumer(topic, name, messageSelector, noLocal);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        return this.getDelegate().createSharedDurableConsumer(topic, name);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        return this.getDelegate().createSharedDurableConsumer(topic, name, messageSelector);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        return this.getDelegate().createSharedConsumer(topic, sharedSubscriptionName);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        return this.getDelegate().createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
    }

    public QueueBrowser createBrowser(Queue queue) {
        return this.getDelegate().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        return this.getDelegate().createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() {
        return this.getDelegate().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() {
        return this.getDelegate().createTemporaryTopic();
    }

    public void unsubscribe(String name) {
        this.getDelegate().unsubscribe(name);
    }

    public void acknowledge() {
        throw MessagingLogger.ROOT_LOGGER.callNotPermittedOnInjectedJMSContext();
    }
}

