/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueRequestor;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.management.JMSManagementHelper;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class DestinationConfiguration {
    private final boolean durable;
    private final String selector;
    private final String name;
    private final String managementQueueAddress;
    private final String managementUsername;
    private final String managementPassword;
    private final String resourceAdapter;
    private final ServiceName destinationServiceName;

    public DestinationConfiguration(boolean durable, String selector, String name, String managementQueueAddress, String managementUsername, String managementPassword, String resourceAdapter, ServiceName destinationServiceName) {
        this.durable = durable;
        this.selector = selector;
        this.name = name;
        this.managementQueueAddress = managementQueueAddress;
        this.managementUsername = managementUsername;
        this.managementPassword = managementPassword;
        this.resourceAdapter = resourceAdapter;
        this.destinationServiceName = destinationServiceName;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public String getSelector() {
        return this.selector;
    }

    public String getName() {
        return this.name;
    }

    public ServiceName getDestinationServiceName() {
        return this.destinationServiceName;
    }

    public String getResourceAdapter() {
        return this.resourceAdapter;
    }

    public Queue getManagementQueue() {
        return ActiveMQJMSClient.createQueue((String)this.managementQueueAddress);
    }

    private Connection createQueueConnection(ConnectionFactory cf) throws JMSException {
        if (this.managementUsername != null && !this.managementUsername.isEmpty()) {
            return cf.createConnection(this.managementUsername, this.managementPassword);
        }
        return cf.createConnection();
    }

    public void createQueue(ConnectionFactory cf, Queue managementQueue, String queueName) throws JMSException, StartException {
        try (Connection connection = this.createQueueConnection(cf);){
            String body;
            Session session = connection.createSession(false, 1);
            connection.start();
            QueueRequestor requestor = new QueueRequestor((QueueSession)session, managementQueue);
            Message m = session.createMessage();
            if (this.getSelector() != null && !this.getSelector().isEmpty()) {
                JMSManagementHelper.putOperationInvocation((Message)m, (String)"broker", (String)"createQueue", (Object[])new Object[]{queueName, queueName, this.getSelector(), this.isDurable(), RoutingType.ANYCAST.name()});
            } else {
                JMSManagementHelper.putOperationInvocation((Message)m, (String)"broker", (String)"createQueue", (Object[])new Object[]{queueName, queueName, this.isDurable(), RoutingType.ANYCAST.name()});
            }
            Message reply = requestor.request(m);
            MessagingLogger.ROOT_LOGGER.infof("Creating queue %s returned %s", queueName, reply);
            if (!reply.getBooleanProperty("_AMQ_OperationSucceeded") && !this.destinationAlreadyExist(body = (String)reply.getBody(String.class))) {
                throw MessagingLogger.ROOT_LOGGER.remoteDestinationCreationFailed(queueName, body);
            }
            MessagingLogger.ROOT_LOGGER.infof("Queue %s has been created", queueName);
        }
    }

    private boolean destinationAlreadyExist(String body) {
        return body.contains("AMQ119019") || body.contains("AMQ119018") || body.contains("AMQ229019") || body.contains("AMQ229018") || body.contains("AMQ229204");
    }

    public void destroyQueue(ConnectionFactory cf, Queue managementQueue, String queueName) throws JMSException {
        try (Connection connection = this.createQueueConnection(cf);){
            Session session = connection.createSession(false, 1);
            connection.start();
            QueueRequestor requestor = new QueueRequestor((QueueSession)session, managementQueue);
            Message m = session.createMessage();
            JMSManagementHelper.putOperationInvocation((Message)m, (String)"broker", (String)"destroyQueue", (Object[])new Object[]{queueName, true, true});
            Message reply = requestor.request(m);
            MessagingLogger.ROOT_LOGGER.debugf("Deleting queue %s returned %s", queueName, reply);
            if (!reply.getBooleanProperty("_AMQ_OperationSucceeded")) {
                throw MessagingLogger.ROOT_LOGGER.remoteDestinationDeletionFailed(queueName, (String)reply.getBody(String.class));
            }
            MessagingLogger.ROOT_LOGGER.debugf("Queue %s has been deleted", queueName);
        }
    }

    public void createTopic(ConnectionFactory cf, Queue managementQueue, String topicName) throws JMSException, StartException {
        try (Connection connection = this.createQueueConnection(cf);){
            String body;
            Session session = connection.createSession(false, 1);
            connection.start();
            QueueRequestor requestor = new QueueRequestor((QueueSession)session, managementQueue);
            Message m = session.createMessage();
            JMSManagementHelper.putOperationInvocation((Message)m, (String)"broker", (String)"createAddress", (Object[])new Object[]{topicName, RoutingType.MULTICAST.name()});
            Message reply = requestor.request(m);
            MessagingLogger.ROOT_LOGGER.infof("Creating topic %s returned %s", topicName, reply);
            if (!reply.getBooleanProperty("_AMQ_OperationSucceeded") && !this.destinationAlreadyExist(body = (String)reply.getBody(String.class))) {
                throw MessagingLogger.ROOT_LOGGER.remoteDestinationCreationFailed(topicName, body);
            }
            MessagingLogger.ROOT_LOGGER.infof("Topic %s has been created", topicName);
        }
    }

    public void destroyTopic(ConnectionFactory cf, Queue managementQueue, String topicName) throws JMSException {
        try (Connection connection = this.createQueueConnection(cf);){
            Session session = connection.createSession(false, 1);
            connection.start();
            QueueRequestor requestor = new QueueRequestor((QueueSession)session, managementQueue);
            Message m = session.createMessage();
            JMSManagementHelper.putOperationInvocation((Message)m, (String)"broker", (String)"deleteAddress", (Object[])new Object[]{topicName, true});
            Message reply = requestor.request(m);
            MessagingLogger.ROOT_LOGGER.debugf("Deleting topic " + topicName + " returned " + reply, new Object[0]);
            if (!reply.getBooleanProperty("_AMQ_OperationSucceeded")) {
                throw MessagingLogger.ROOT_LOGGER.remoteDestinationDeletionFailed(topicName, (String)reply.getBody(String.class));
            }
            MessagingLogger.ROOT_LOGGER.debugf("Topic %s has been deleted", topicName);
        }
    }

    public static class Builder {
        private boolean durable = false;
        private String selector = null;
        private String name;
        private String managementQueueAddress = "activemq.management";
        private String managementUsername = null;
        private String managementPassword = null;
        private String resourceAdapter;
        private ServiceName destinationServiceName;

        private Builder() {
        }

        public static Builder getInstance() {
            return new Builder();
        }

        public Builder setDurable(boolean durable) {
            this.durable = durable;
            return this;
        }

        public Builder setSelector(String selector) {
            this.selector = selector;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDestinationServiceName(ServiceName destinationServiceName) {
            this.destinationServiceName = destinationServiceName;
            return this;
        }

        public Builder setResourceAdapter(String resourceAdapter) {
            this.resourceAdapter = resourceAdapter;
            return this;
        }

        public Builder setManagementQueueAddress(String managementQueueAddress) {
            this.managementQueueAddress = managementQueueAddress;
            return this;
        }

        public Builder setManagementUsername(String managementUsername) {
            this.managementUsername = managementUsername;
            return this;
        }

        public Builder setManagementPassword(String managementPassword) {
            this.managementPassword = managementPassword;
            return this;
        }

        public DestinationConfiguration build() {
            return new DestinationConfiguration(this.durable, this.selector, this.name, this.managementQueueAddress, this.managementUsername, this.managementPassword, this.resourceAdapter, this.destinationServiceName);
        }
    }
}

