/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import jakarta.jms.ConnectionFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.spi.dispatcher.CommandDispatcherFactory;
import org.wildfly.extension.messaging.activemq.JGroupsDiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.SocketDiscoveryGroupAdd;
import org.wildfly.extension.messaging.activemq.TransportConfigOperationHandlers;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ExternalConnectionFactoryService
implements Service<ConnectionFactory> {
    private final boolean ha;
    private final boolean enable1Prefixes;
    private final DiscoveryGroupConfiguration groupConfiguration;
    private final TransportConfiguration[] connectors;
    private final JMSFactoryType type;
    private final Map<String, Supplier<SocketBinding>> socketBindings;
    private final Map<String, Supplier<OutboundSocketBinding>> outboundSocketBindings;
    private final Map<String, Supplier<SocketBinding>> groupBindings;
    private final Map<String, String> clusterNames;
    private final Map<String, Supplier<CommandDispatcherFactory>> commandDispatcherFactories;
    private ActiveMQConnectionFactory factory;
    private final ConnectionFactoryConfiguration config;

    ExternalConnectionFactoryService(DiscoveryGroupConfiguration groupConfiguration, Map<String, Supplier<CommandDispatcherFactory>> commandDispatcherFactories, Map<String, Supplier<SocketBinding>> groupBindings, Map<String, String> clusterNames, JMSFactoryType type, boolean ha, boolean enable1Prefixes, ConnectionFactoryConfiguration config) {
        this(ha, enable1Prefixes, type, groupConfiguration, Collections.emptyMap(), Collections.emptyMap(), commandDispatcherFactories, groupBindings, clusterNames, null, config);
    }

    ExternalConnectionFactoryService(TransportConfiguration[] connectors, Map<String, Supplier<SocketBinding>> socketBindings, Map<String, Supplier<OutboundSocketBinding>> outboundSocketBindings, JMSFactoryType type, boolean ha, boolean enable1Prefixes, ConnectionFactoryConfiguration config) {
        this(ha, enable1Prefixes, type, null, socketBindings, outboundSocketBindings, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), connectors, config);
    }

    private ExternalConnectionFactoryService(boolean ha, boolean enable1Prefixes, JMSFactoryType type, DiscoveryGroupConfiguration groupConfiguration, Map<String, Supplier<SocketBinding>> socketBindings, Map<String, Supplier<OutboundSocketBinding>> outboundSocketBindings, Map<String, Supplier<CommandDispatcherFactory>> commandDispatcherFactories, Map<String, Supplier<SocketBinding>> groupBindings, Map<String, String> clusterNames, TransportConfiguration[] connectors, ConnectionFactoryConfiguration config) {
        assert (connectors != null && connectors.length > 0 || groupConfiguration != null);
        this.ha = ha;
        this.enable1Prefixes = enable1Prefixes;
        this.type = type;
        this.groupConfiguration = groupConfiguration;
        this.connectors = connectors;
        this.socketBindings = socketBindings;
        this.outboundSocketBindings = outboundSocketBindings;
        this.clusterNames = clusterNames;
        this.commandDispatcherFactories = commandDispatcherFactories;
        this.groupBindings = groupBindings;
        this.config = config;
    }

    public void start(StartContext context) throws StartException {
        try {
            if (this.connectors != null && this.connectors.length > 0) {
                TransportConfigOperationHandlers.processConnectorBindings(Arrays.asList(this.connectors), this.socketBindings, this.outboundSocketBindings);
                this.factory = this.ha ? ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)this.type, (TransportConfiguration[])this.connectors) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)this.type, (TransportConfiguration[])this.connectors);
            } else {
                DiscoveryGroupConfiguration config;
                String name = this.groupConfiguration.getName();
                String key = "discovery" + name;
                if (this.commandDispatcherFactories.containsKey(key)) {
                    CommandDispatcherFactory commandDispatcherFactory = this.commandDispatcherFactories.get(key).get();
                    String clusterName = this.clusterNames.get(key);
                    config = JGroupsDiscoveryGroupAdd.createDiscoveryGroupConfiguration(name, this.groupConfiguration, commandDispatcherFactory, clusterName);
                } else {
                    SocketBinding binding = this.groupBindings.get(key).get();
                    if (binding == null) {
                        throw MessagingLogger.ROOT_LOGGER.failedToFindDiscoverySocketBinding(name);
                    }
                    config = SocketDiscoveryGroupAdd.createDiscoveryGroupConfiguration(name, this.groupConfiguration, binding);
                    binding.getSocketBindings().getNamedRegistry().registerBinding(ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)binding));
                }
                this.factory = this.ha ? ActiveMQJMSClient.createConnectionFactoryWithHA((DiscoveryGroupConfiguration)config, (JMSFactoryType)this.type) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)config, (JMSFactoryType)this.type);
            }
            if (this.config != null) {
                this.factory.setAutoGroup(this.config.isAutoGroup());
                this.factory.setBlockOnAcknowledge(this.config.isBlockOnAcknowledge());
                this.factory.setBlockOnDurableSend(this.config.isBlockOnDurableSend());
                this.factory.setBlockOnNonDurableSend(this.config.isBlockOnNonDurableSend());
                this.factory.setCacheLargeMessagesClient(this.config.isCacheLargeMessagesClient());
                this.factory.setCallFailoverTimeout(this.config.getCallFailoverTimeout());
                this.factory.setCallTimeout(this.config.getCallTimeout());
                this.factory.setClientID(this.config.getClientID());
                this.factory.setClientFailureCheckPeriod(this.config.getClientFailureCheckPeriod());
                this.factory.setCompressLargeMessage(this.config.isCompressLargeMessages());
                this.factory.setConfirmationWindowSize(this.config.getConfirmationWindowSize());
                this.factory.setConnectionTTL(this.config.getConnectionTTL());
                this.factory.setConsumerMaxRate(this.config.getConsumerMaxRate());
                this.factory.setConsumerWindowSize(this.config.getConsumerWindowSize());
                this.factory.setDeserializationBlackList(this.config.getDeserializationBlackList());
                this.factory.setDeserializationWhiteList(this.config.getDeserializationWhiteList());
                this.factory.setDupsOKBatchSize(this.config.getDupsOKBatchSize());
                this.factory.setEnableSharedClientID(this.config.isEnableSharedClientID());
                this.factory.setFailoverOnInitialConnection(this.config.isFailoverOnInitialConnection());
                this.factory.setGroupID(this.config.getGroupID());
                this.factory.setInitialMessagePacketSize(this.config.getInitialMessagePacketSize());
                this.factory.setMaxRetryInterval(this.config.getMaxRetryInterval());
                this.factory.setMinLargeMessageSize(this.config.getMinLargeMessageSize());
                this.factory.setPreAcknowledge(this.config.isPreAcknowledge());
                this.factory.setProducerMaxRate(this.config.getProducerMaxRate());
                this.factory.setProducerWindowSize(this.config.getProducerWindowSize());
                this.factory.setProtocolManagerFactoryStr(this.config.getProtocolManagerFactoryStr());
                this.factory.setConnectionLoadBalancingPolicyClassName(this.config.getLoadBalancingPolicyClassName());
                this.factory.setReconnectAttempts(this.config.getReconnectAttempts());
                this.factory.setRetryInterval(this.config.getRetryInterval());
                this.factory.setRetryIntervalMultiplier(this.config.getRetryIntervalMultiplier());
                this.factory.setScheduledThreadPoolMaxSize(this.config.getScheduledThreadPoolMaxSize());
                this.factory.setThreadPoolMaxSize(this.config.getThreadPoolMaxSize());
                this.factory.setTransactionBatchSize(this.config.getTransactionBatchSize());
                this.factory.setUseGlobalPools(this.config.isUseGlobalPools());
                this.factory.setUseTopologyForLoadBalancing(this.config.getUseTopologyForLoadBalancing());
            }
            this.factory.setEnable1xPrefixes(this.enable1Prefixes);
        }
        catch (Throwable e) {
            throw MessagingLogger.ROOT_LOGGER.failedToCreate(e, "connection-factory");
        }
    }

    public void stop(StopContext context) {
        try {
            this.factory.close();
        }
        catch (Throwable e) {
            MessagingLogger.ROOT_LOGGER.failedToDestroy("connection-factory", "");
        }
    }

    public ConnectionFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this.factory;
    }
}

