/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan.scheduler;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.util.concurrent.CompletableFutures;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ee.cache.Key;
import org.wildfly.clustering.ee.infinispan.scheduler.Scheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.SchedulerListener;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener
public class SchedulerTopologyChangeListener<I, K extends Key<I>, V>
implements SchedulerListener {
    private final Cache<K, V> cache;
    private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory(SchedulerTopologyChangeListener.class));
    private final AtomicReference<Future<?>> rehashFuture = new AtomicReference();
    private final AtomicInteger rehashTopology = new AtomicInteger();
    private final Consumer<Locality> cancelTask;
    private final BiConsumer<Locality, Locality> scheduleTask;

    public SchedulerTopologyChangeListener(Cache<K, V> cache, Scheduler<I, ?> scheduler, BiConsumer<Locality, Locality> scheduleTask) {
        this(cache, scheduler::cancel, scheduleTask);
    }

    public SchedulerTopologyChangeListener(Cache<K, V> cache, Consumer<Locality> cancelTask, BiConsumer<Locality, Locality> scheduleTask) {
        this.cache = cache;
        this.cancelTask = cancelTask;
        this.scheduleTask = scheduleTask;
        this.cache.addListener((Object)this);
    }

    @Override
    public void close() {
        this.cache.removeListener((Object)this);
        WildFlySecurityManager.doUnchecked((Object)this.executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @DataRehashed
    public CompletionStage<Void> dataRehashed(DataRehashedEvent<K, V> event) {
        if (event.isPre()) {
            this.rehashTopology.set(event.getNewTopologyId());
            this.cancel(event.getCache(), event.getConsistentHashAtEnd());
        } else {
            this.rehashTopology.compareAndSet(event.getNewTopologyId(), 0);
            this.schedule(event.getCache(), event.getConsistentHashAtStart(), event.getConsistentHashAtEnd());
        }
        return CompletableFutures.completedNull();
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<K, V> event) {
        if (!event.isPre() && this.rehashTopology.get() != event.getNewTopologyId()) {
            this.schedule(event.getCache(), event.getReadConsistentHashAtStart(), event.getWriteConsistentHashAtEnd());
        }
        return CompletableFutures.completedNull();
    }

    private void cancel(Cache<K, V> cache, ConsistentHash hash) {
        Future future = this.rehashFuture.getAndSet(null);
        if (future != null) {
            future.cancel(true);
        }
        try {
            this.executor.submit(() -> this.cancelTask.accept((Locality)new ConsistentHashLocality(cache, hash)));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void schedule(Cache<K, V> cache, ConsistentHash oldHash, ConsistentHash newHash) {
        if (!newHash.getPrimarySegmentsForOwner(cache.getCacheManager().getAddress()).isEmpty()) {
            ConsistentHashLocality oldLocality = new ConsistentHashLocality(cache, oldHash);
            ConsistentHashLocality newLocality = new ConsistentHashLocality(cache, newHash);
            try {
                Future<?> future = this.rehashFuture.getAndSet(this.executor.submit(() -> this.lambda$schedule$1((Locality)oldLocality, (Locality)newLocality)));
                if (future != null) {
                    future.cancel(true);
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private /* synthetic */ void lambda$schedule$1(Locality oldLocality, Locality newLocality) {
        this.scheduleTask.accept(oldLocality, newLocality);
    }
}

