/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.constraint;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.JmxAction;
import org.jboss.as.controller.access.JmxTarget;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.constraint.AbstractConstraintFactory;
import org.jboss.as.controller.access.constraint.AllowAllowNotConstraint;
import org.jboss.as.controller.access.constraint.Constraint;
import org.jboss.as.controller.access.constraint.ConstraintFactory;
import org.jboss.as.controller.access.rbac.StandardRole;

public class TopRoleConstraint
extends AllowAllowNotConstraint {
    private static final PathElement MGMT_ELEMENT = PathElement.pathElement("core-service", "management");
    private static final PathElement AUTHZ_ELEMENT = PathElement.pathElement("access", "authorization");
    public static final ConstraintFactory FACTORY = new Factory();
    private static final TopRoleConstraint TOP_ROLE = new TopRoleConstraint(true);
    private static final TopRoleConstraint NOT_TOP_ROLE = new TopRoleConstraint(false);
    private static final TopRoleConstraint ALLOWS = new TopRoleConstraint(true, true);
    private static final TopRoleConstraint DISALLOWS = new TopRoleConstraint(false, true);

    private TopRoleConstraint(boolean isTopRole) {
        super(isTopRole);
    }

    private TopRoleConstraint(boolean allowsTopRole, boolean allowsNonTopRole) {
        super(allowsTopRole, allowsNonTopRole);
    }

    static class Factory
    extends AbstractConstraintFactory {
        Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            if (actionEffect != Action.ActionEffect.WRITE_CONFIG && actionEffect != Action.ActionEffect.WRITE_RUNTIME) {
                return ALLOWS;
            }
            return role == StandardRole.SUPERUSER ? ALLOWS : DISALLOWS;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.getRequiredConstraint(actionEffect, action, target.getTargetResource());
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.isTopRole(target) ? TOP_ROLE : NOT_TOP_ROLE;
        }

        private boolean isTopRole(TargetResource target) {
            return this.isTopRole(target.getResourceAddress());
        }

        private boolean isTopRole(PathAddress address) {
            PathElement roleMapping;
            if (address.size() >= 3 && MGMT_ELEMENT.equals(address.getElement(0)) && AUTHZ_ELEMENT.equals(address.getElement(1)) && "role-mapping".equals((roleMapping = address.getElement(2)).getKey())) {
                String roleName = roleMapping.getValue();
                return StandardRole.AUDITOR.name().equalsIgnoreCase(roleName) || StandardRole.SUPERUSER.name().equalsIgnoreCase(roleName);
            }
            return false;
        }

        @Override
        protected int internalCompare(AbstractConstraintFactory other) {
            return 0;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, JmxAction action, JmxTarget target) {
            return NOT_TOP_ROLE;
        }
    }
}

