/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.UnaryOperator;
import org.infinispan.Cache;
import org.jboss.as.clustering.controller.FunctionExecutorRegistry;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.transform.RequiredChildResourceDiscardPolicy;
import org.jboss.as.clustering.infinispan.subsystem.BackupForResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BackupsResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;

public class SharedStateCacheResourceDefinition
extends ClusteredCacheResourceDefinition {
    private final FunctionExecutorRegistry<Cache<?, ?>> executors;

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder builder) {
        StateTransferResourceDefinition.buildTransformation(version, builder);
        if (InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
            builder.addChildResource(PartitionHandlingResourceDefinition.PATH, (DynamicDiscardPolicy)RequiredChildResourceDiscardPolicy.REJECT_AND_WARN);
        } else {
            PartitionHandlingResourceDefinition.buildTransformation(version, builder);
        }
        if (InfinispanModel.VERSION_2_0_0.requiresTransformation(version)) {
            ResourceTransformationDescriptionBuilder backupsBuilder = builder.addChildResource(BackupsResourceDefinition.PATH, (DynamicDiscardPolicy)RequiredChildResourceDiscardPolicy.REJECT_AND_WARN);
            backupsBuilder.rejectChildResource(BackupResourceDefinition.WILDCARD_PATH);
            builder.addChildResource(BackupForResourceDefinition.PATH, (DynamicDiscardPolicy)RequiredChildResourceDiscardPolicy.REJECT_AND_WARN);
        } else {
            BackupsResourceDefinition.buildTransformation(version, builder);
            BackupForResourceDefinition.buildTransformation(version, builder);
        }
        ClusteredCacheResourceDefinition.buildTransformation(version, builder);
    }

    SharedStateCacheResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator, ClusteredCacheServiceHandler handler, FunctionExecutorRegistry<Cache<?, ?>> executors) {
        super(path, (UnaryOperator<ResourceDescriptor>)new ResourceDescriptorConfigurator(configurator), handler, executors);
        this.executors = executors;
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        new PartitionHandlingResourceDefinition().register(registration);
        new StateTransferResourceDefinition().register(registration);
        new BackupsResourceDefinition(this.executors).register(registration);
        new BackupForResourceDefinition().register(registration);
        return registration;
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).addRequiredChildren(new PathElement[]{PartitionHandlingResourceDefinition.PATH, StateTransferResourceDefinition.PATH, BackupForResourceDefinition.PATH, BackupsResourceDefinition.PATH});
        }
    }
}

