/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509;

import jakarta.annotation.Nonnull;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.Criterion;

public final class X509SubjectNameCriterion
implements Criterion {
    private X500Principal subjectName;

    public X509SubjectNameCriterion(@Nonnull X500Principal subject) {
        this.setSubjectName(subject);
    }

    @Nonnull
    public X500Principal getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(@Nonnull X500Principal subject) {
        Constraint.isNotNull((Object)subject, (String)"Subject principal criteria value cannot be null");
        this.subjectName = subject;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("X509SubjectNameCriterion [subjectName=");
        builder.append(this.subjectName.getName());
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.subjectName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof X509SubjectNameCriterion) {
            return this.subjectName.equals(((X509SubjectNameCriterion)obj).subjectName);
        }
        return false;
    }
}

