/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.util.function.Consumer;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.services.bootstrap.JTSSynchronizationWrapper;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.LocalUserTransaction;

public class WeldTransactionServices
implements TransactionServices,
Service {
    public static final ServiceName SERVICE_NAME = ServiceNames.WELD_TRANSACTION_SERVICES_SERVICE_NAME;
    private final Consumer<WeldTransactionServices> weldTransactionServicesConsumer;
    private final boolean jtsEnabled;

    public WeldTransactionServices(boolean jtsEnabled, Consumer<WeldTransactionServices> weldTransactionServicesConsumer) {
        this.jtsEnabled = jtsEnabled;
        this.weldTransactionServicesConsumer = weldTransactionServicesConsumer;
    }

    public UserTransaction getUserTransaction() {
        return LocalUserTransaction.getInstance();
    }

    public boolean isTransactionActive() {
        try {
            int status = ContextTransactionManager.getInstance().getStatus();
            return status == 0 || status == 8 || status == 1 || status == 2 || status == 7 || status == 9;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanup() {
    }

    public void registerSynchronization(Synchronization synchronizedObserver) {
        try {
            Object synchronization = !this.jtsEnabled ? synchronizedObserver : new JTSSynchronizationWrapper(synchronizedObserver);
            ContextTransactionManager.getInstance().getTransaction().registerSynchronization(synchronization);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
        catch (RollbackException e) {
            throw new RuntimeException(e);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(StartContext context) {
        this.weldTransactionServicesConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.weldTransactionServicesConsumer.accept(null);
    }
}

