/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.logging;

import jakarta.enterprise.inject.spi.InjectionPoint;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Set;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.resources.spi.ClassFileInfoException;

@MessageLogger(projectCode="WFLYWELD", length=4)
public interface WeldLogger
extends BasicLogger {
    public static final WeldLogger ROOT_LOGGER = (WeldLogger)Logger.getMessageLogger(WeldLogger.class, (String)"org.jboss.as.weld");
    public static final WeldLogger DEPLOYMENT_LOGGER = (WeldLogger)Logger.getMessageLogger(WeldLogger.class, (String)"org.jboss.weld.deployer");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="Failed to setup Weld contexts")
    public void failedToSetupWeldContexts(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Failed to tear down Weld contexts")
    public void failedToTearDownWeldContexts(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Processing weld deployment %s")
    public void processingWeldDeployment(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Could not find BeanManager for deployment %s")
    public void couldNotFindBeanManagerForDeployment(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=6, value="Starting Services for CDI deployment: %s")
    public void startingServicesForCDIDeployment(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Could not load portable extension class %s")
    public void couldNotLoadPortableExceptionClass(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8, value="@Resource injection of type %s is not supported for non-ejb components. Injection point: %s")
    public void injectionTypeNotValue(String var1, Member var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=9, value="Starting weld service for deployment %s")
    public void startingWeldService(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10, value="Stopping weld service for deployment %s")
    public void stoppingWeldService(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="Warning while parsing %s:%s %s")
    public void beansXmlValidationWarning(URL var1, int var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="Warning while parsing %s:%s %s")
    public void beansXmlValidationError(URL var1, int var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="Deployment %s contains CDI annotations but no bean archive was found (no beans.xml or class with bean defining annotations was present).")
    public void cdiAnnotationsButNotBeanArchive(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14, value="Exception tearing down thread state")
    public void exceptionClearingThreadState(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16, value="Could not read entries")
    public void couldNotReadEntries(@Cause IOException var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17, value="URL scanner does not understand the URL protocol %s, CDI beans will not be scanned.")
    public void doNotUnderstandProtocol(URL var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18, value="Found both WEB-INF/beans.xml and WEB-INF/classes/META-INF/beans.xml. It is not portable to use both locations at the same time. Weld is going to use the former location for this deployment.")
    public void duplicateBeansXml();

    @Message(id=19, value="Could get beans.xml file as URL when processing file: %s")
    public DeploymentUnitProcessingException couldNotGetBeansXmlAsURL(String var1, @Cause Throwable var2);

    @Message(id=20, value="Could not load interceptor class : %s")
    public DeploymentUnitProcessingException couldNotLoadInterceptorClass(String var1, @Cause Throwable var2);

    @Message(id=21, value="Service %s didn't implement the jakarta.enterprise.inject.spi.Extension interface")
    public DeploymentUnitProcessingException extensionDoesNotImplementExtension(Class<?> var1);

    @Message(id=22, value="View of type %s not found on EJB %s")
    public IllegalArgumentException viewNotFoundOnEJB(String var1, String var2);

    @Message(id=30, value="Unknown interceptor class for CDI injection %s")
    public IllegalArgumentException unknownInterceptorClassForCDIInjection(Class<?> var1);

    @Message(id=31, value="%s cannot be null")
    public IllegalArgumentException parameterCannotBeNull(String var1);

    @Message(id=32, value="Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) %s")
    public IllegalArgumentException injectionPointNotAJavabean(Method var1);

    @Message(id=33, value="%s annotation not found on %s")
    public IllegalArgumentException annotationNotFound(Class<? extends Annotation> var1, Member var2);

    @Message(id=34, value="Could not resolve @EJB injection for %s on %s")
    public IllegalStateException ejbNotResolved(Object var1, Member var2);

    @Message(id=35, value="Resolved more than one EJB for @EJB injection of %s on %s. Found %s")
    public IllegalStateException moreThanOneEjbResolved(Object var1, Member var2, Set<ViewDescription> var3);

    @Message(id=36, value="Could not determine bean class from injection point type of %s")
    public IllegalArgumentException couldNotDetermineUnderlyingType(Type var1);

    @Message(id=37, value="Error injecting persistence unit into CDI managed bean. Can't find a persistence unit named '%s' in deployment %s for injection point %s")
    public IllegalArgumentException couldNotFindPersistenceUnit(String var1, String var2, Member var3);

    @Message(id=38, value="Could not inject SecurityManager, security is not enabled")
    public IllegalStateException securityNotEnabled();

    @Message(id=39, value="Singleton not set for %s. This means that you are trying to access a weld deployment with a Thread Context ClassLoader that is not associated with the deployment.")
    public IllegalStateException singletonNotSet(ClassLoader var1);

    @Message(id=40, value="%s is already running")
    public IllegalStateException alreadyRunning(String var1);

    @Message(id=41, value="%s is not started")
    public IllegalStateException notStarted(String var1);

    @Message(id=43, value="BeanDeploymentArchive with id %s not found in deployment")
    public IllegalArgumentException beanDeploymentNotFound(String var1);

    @Message(id=44, value="Error injecting resource into CDI managed bean. Can't find a resource named %s")
    public IllegalArgumentException couldNotFindResource(String var1, @Cause Throwable var2);

    @Message(id=45, value="Cannot determine resource name. Both jndiName and mappedName are null")
    public IllegalArgumentException cannotDetermineResourceName();

    @Message(id=46, value="Cannot inject injection point %s")
    public IllegalArgumentException cannotInject(InjectionPoint var1);

    @Message(id=47, value="%s cannot be used at runtime")
    public IllegalStateException cannotUseAtRuntime(String var1);

    @Message(id=48, value="These attributes must be 'true' for use with CDI 1.0 '%s'")
    public String rejectAttributesMustBeTrue(Set<String> var1);

    @Message(id=49, value="Error injecting resource into CDI managed bean. Can't find a resource named %s defined on %s")
    public IllegalArgumentException couldNotFindResource(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Discovered %s")
    public void beanArchiveDiscovered(BeanDeploymentArchive var1);

    @Message(id=50, value="%s was not found in composite index")
    public ClassFileInfoException nameNotFoundInIndex(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=0, value="Unable to load annotation %s")
    public void unableToLoadAnnotation(String var1);

    @Message(id=51, value="Cannot load %s")
    public ClassFileInfoException cannotLoadClass(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=52, value="Using deployment classloader to load proxy classes for module %s. Package-private access will not work. To fix this the module should declare dependencies on %s")
    public void loadingProxiesUsingDeploymentClassLoader(ModuleIdentifier var1, String var2);

    @Message(id=53, value="Component interceptor support not available for: %s")
    public IllegalStateException componentInterceptorSupportNotAvailable(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=54, value="Could not read provided index of an external bean archive: %s")
    public void cannotLoadAnnotationIndexOfExternalBeanArchive(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=55, value="Could not index class [%s] from an external bean archive: %s")
    public void cannotIndexClassName(Object var1, Object var2);

    @Message(id=56, value="Weld is not initialized yet")
    public IllegalStateException weldNotInitialized();
}

