/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Collection;
import java.util.Map;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.CapabilityRegistration;
import org.jboss.as.clustering.controller.ReadAttributeTranslationHandler;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.WriteAttributeStepHandler;
import org.jboss.as.clustering.controller.WriteAttributeTranslationHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.controller.operations.global.WriteAttributeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;

public class ResourceRegistration
implements Registration<ManagementResourceRegistration> {
    private final AddStepHandlerDescriptor descriptor;
    private final Registration<ManagementResourceRegistration> addRegistration;
    private final Registration<ManagementResourceRegistration> removeRegistration;
    private final Registration<ManagementResourceRegistration> writeAttributeRegistration;

    protected ResourceRegistration(AddStepHandlerDescriptor descriptor, ResourceServiceHandler handler, Registration<ManagementResourceRegistration> addRegistration, Registration<ManagementResourceRegistration> removeRegistration) {
        this(descriptor, addRegistration, removeRegistration, (Registration<ManagementResourceRegistration>)new WriteAttributeStepHandler(descriptor, handler));
    }

    protected ResourceRegistration(AddStepHandlerDescriptor descriptor, Registration<ManagementResourceRegistration> addRegistration, Registration<ManagementResourceRegistration> removeRegistration, Registration<ManagementResourceRegistration> writeAttributeRegistration) {
        this.descriptor = descriptor;
        this.addRegistration = addRegistration;
        this.removeRegistration = removeRegistration;
        this.writeAttributeRegistration = writeAttributeRegistration;
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        new CapabilityRegistration(this.descriptor.getCapabilities().keySet()).register(registration);
        registration.registerRequirements(this.descriptor.getResourceCapabilityReferences());
        this.writeAttributeRegistration.register(registration);
        for (Map.Entry<AttributeDefinition, OperationStepHandler> entry : this.descriptor.getCustomAttributes().entrySet()) {
            registration.registerReadWriteAttribute(entry.getKey(), null, entry.getValue());
        }
        Collection<AttributeDefinition> ignoredAttributes = this.descriptor.getIgnoredAttributes();
        if (!ignoredAttributes.isEmpty()) {
            ModelOnlyWriteAttributeHandler writeHandler = new ModelOnlyWriteAttributeHandler(ignoredAttributes);
            for (AttributeDefinition ignoredAttribute : ignoredAttributes) {
                registration.registerReadWriteAttribute(ignoredAttribute, null, (OperationStepHandler)writeHandler);
            }
        }
        for (Map.Entry<AttributeDefinition, AttributeTranslation> entry : this.descriptor.getAttributeTranslations().entrySet()) {
            AttributeTranslation translation = entry.getValue();
            registration.registerReadWriteAttribute(entry.getKey(), (OperationStepHandler)new ReadAttributeTranslationHandler(translation), (OperationStepHandler)new WriteAttributeTranslationHandler(translation));
        }
        this.addRegistration.register(registration);
        this.removeRegistration.register(registration);
        this.registerTransformedOperation(registration, WriteAttributeHandler.DEFINITION, WriteAttributeHandler.INSTANCE);
        this.registerTransformedOperation(registration, MapOperations.MAP_PUT_DEFINITION, MapOperations.MAP_PUT_HANDLER);
        this.registerTransformedOperation(registration, MapOperations.MAP_GET_DEFINITION, MapOperations.MAP_GET_HANDLER);
        this.registerTransformedOperation(registration, MapOperations.MAP_REMOVE_DEFINITION, MapOperations.MAP_REMOVE_HANDLER);
        this.registerTransformedOperation(registration, MapOperations.MAP_CLEAR_DEFINITION, MapOperations.MAP_CLEAR_HANDLER);
        this.registerTransformedOperation(registration, ListOperations.LIST_ADD_DEFINITION, ListOperations.LIST_ADD_HANDLER);
        this.registerTransformedOperation(registration, ListOperations.LIST_GET_DEFINITION, ListOperations.LIST_GET_HANDLER);
        this.registerTransformedOperation(registration, ListOperations.LIST_REMOVE_DEFINITION, ListOperations.LIST_REMOVE_HANDLER);
        this.registerTransformedOperation(registration, ListOperations.LIST_CLEAR_DEFINITION, ListOperations.LIST_CLEAR_HANDLER);
    }

    private void registerTransformedOperation(ManagementResourceRegistration registration, OperationDefinition definition, OperationStepHandler handler) {
        OperationStepHandler transformedHandler = (OperationStepHandler)this.descriptor.getOperationTransformation().apply(handler);
        if (handler != transformedHandler) {
            registration.registerOperationHandler(definition, transformedHandler);
        }
    }
}

