/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.predicate.Predicate;
import io.undertow.predicate.PredicateParser;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.undertow.FilterLocation;
import org.wildfly.extension.undertow.PredicateValidator;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.filters.FilterRef;
import org.wildfly.extension.undertow.filters.FilterService;

public class FilterRefDefinition
extends PersistentResourceDefinition {
    public static final AttributeDefinition PREDICATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("predicate", ModelType.STRING).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).setValidator((ParameterValidator)PredicateValidator.INSTANCE)).build();
    public static final AttributeDefinition PRIORITY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("priority", ModelType.INT).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(1))).setValidator((ParameterValidator)new IntRangeValidator(1, true, true))).setRestartAllServices()).build();
    public static final FilterRefDefinition INSTANCE = new FilterRefDefinition();

    private FilterRefDefinition() {
        super(UndertowExtension.PATH_FILTER_REF, (ResourceDescriptionResolver)UndertowExtension.getResolver("filter-ref"), (OperationStepHandler)new FilterRefAdd(), (OperationStepHandler)new ServiceRemoveStepHandler(new FilterRefAdd()){

            protected ServiceName serviceName(String name, PathAddress address) {
                return UndertowService.getFilterRefServiceName(address, name);
            }
        });
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(PREDICATE, PRIORITY);
    }

    static class FilterRefAdd
    extends AbstractAddStepHandler {
        FilterRefAdd() {
            super(new AttributeDefinition[]{PREDICATE, PRIORITY});
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceName locationService;
            PathAddress address = context.getCurrentAddress();
            String name = context.getCurrentAddressValue();
            String locationType = address.getElement(address.size() - 2).getKey();
            if (locationType.equals("host")) {
                PathAddress hostAddress = address.getParent();
                PathAddress serverAddress = hostAddress.getParent();
                String serverName = serverAddress.getLastElement().getValue();
                String hostName = hostAddress.getLastElement().getValue();
                locationService = context.getCapabilityServiceName("org.wildfly.undertow.host", FilterLocation.class, new String[]{serverName, hostName});
            } else {
                PathAddress locationAddress = address.getParent();
                PathAddress hostAddress = locationAddress.getParent();
                PathAddress serverAddress = hostAddress.getParent();
                String locationName = locationAddress.getLastElement().getValue();
                String serverName = serverAddress.getLastElement().getValue();
                String hostName = hostAddress.getLastElement().getValue();
                locationService = context.getCapabilityServiceName("org.wildfly.undertow.host.location", FilterLocation.class, new String[]{serverName, hostName, locationName});
            }
            Predicate predicate = null;
            if (model.hasDefined(PREDICATE.getName())) {
                String predicateString = PREDICATE.resolveModelAttribute(context, model).asString();
                predicate = PredicateParser.parse((String)predicateString, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            }
            int priority = PRIORITY.resolveModelAttribute(context, operation).asInt();
            FilterRef service = new FilterRef(predicate, priority);
            ServiceTarget target = context.getServiceTarget();
            target.addService(UndertowService.getFilterRefServiceName(address, name), (Service)service).addDependency(UndertowService.FILTER.append(new String[]{name}), FilterService.class, service.getFilter()).addDependency(locationService, FilterLocation.class, service.getLocation()).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

